/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.api.process.model.events.IntegrationEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.CloudBPMNActivity;
import org.activiti.cloud.api.process.model.CloudIntegrationContext;
import org.activiti.cloud.api.process.model.events.CloudIntegrationErrorReceivedEvent;
import org.activiti.cloud.api.process.model.events.CloudIntegrationEvent;
import org.activiti.cloud.services.query.events.handlers.BaseIntegrationEventHandler;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.IntegrationContextEntity;
import org.activiti.cloud.services.query.model.ServiceTaskEntity;
import org.apache.commons.lang3.ObjectUtils;

public class IntegrationErrorReceivedEventHandler
extends BaseIntegrationEventHandler
implements QueryEventHandler {
    public IntegrationErrorReceivedEventHandler(EntityManager entityManager) {
        super(entityManager);
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudIntegrationErrorReceivedEvent integrationEvent = (CloudIntegrationErrorReceivedEvent)CloudIntegrationErrorReceivedEvent.class.cast(event);
        Optional<IntegrationContextEntity> integrationContextEntity = this.findIntegrationContextEntity((CloudIntegrationEvent)integrationEvent);
        integrationContextEntity.ifPresent(entity -> {
            entity.setErrorDate(new Date(integrationEvent.getTimestamp()));
            entity.setStatus(CloudIntegrationContext.IntegrationContextStatus.INTEGRATION_ERROR_RECEIVED);
            entity.setErrorCode(integrationEvent.getErrorCode());
            entity.setErrorMessage(integrationEvent.getErrorMessage());
            entity.setErrorClassName(integrationEvent.getErrorClassName());
            entity.setStackTraceElements(this.addFullErrorMessageAsFirstStackTraceElement(integrationEvent));
            entity.setInBoundVariables(((IntegrationContext)integrationEvent.getEntity()).getInBoundVariables());
            entity.setOutBoundVariables(((IntegrationContext)integrationEvent.getEntity()).getOutBoundVariables());
            this.entityManager.persist(entity);
            ServiceTaskEntity serviceTask = entity.getServiceTask();
            if (serviceTask != null) {
                serviceTask.setStatus(CloudBPMNActivity.BPMNActivityStatus.ERROR);
                this.entityManager.persist((Object)serviceTask);
            }
        });
    }

    private List<StackTraceElement> addFullErrorMessageAsFirstStackTraceElement(CloudIntegrationErrorReceivedEvent integrationEvent) {
        StackTraceElement newTopStackTraceElement = this.getNewTopStackTraceElement(integrationEvent);
        ArrayList<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>(List.of(newTopStackTraceElement));
        stackTraceElements.addAll(integrationEvent.getStackTraceElements());
        return stackTraceElements;
    }

    private StackTraceElement getNewTopStackTraceElement(CloudIntegrationErrorReceivedEvent integrationEvent) {
        if (ObjectUtils.isNotEmpty((Object)integrationEvent.getStackTraceElements())) {
            StackTraceElement firstElement = (StackTraceElement)integrationEvent.getStackTraceElements().get(0);
            return new StackTraceElement(integrationEvent.getErrorMessage(), "", firstElement.getFileName(), firstElement.getLineNumber());
        }
        return new StackTraceElement(integrationEvent.getErrorMessage(), "", "", 0);
    }

    @Override
    public String getHandledEvent() {
        return IntegrationEvent.IntegrationEvents.INTEGRATION_ERROR_RECEIVED.name();
    }
}

