/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import org.activiti.api.process.model.ProcessCandidateStarterUser;
import org.activiti.api.process.model.events.ProcessCandidateStarterUserEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessCandidateStarterUserAddedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.ProcessCandidateStarterUserEntity;
import org.activiti.cloud.services.query.model.ProcessCandidateStarterUserId;
import org.activiti.cloud.services.query.model.QueryException;

public class ProcessCandidateStarterUserAddedEventHandler
implements QueryEventHandler {
    private final EntityManager entityManager;

    public ProcessCandidateStarterUserAddedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudProcessCandidateStarterUserAddedEvent processCandidateStarterUserAddedEvent = (CloudProcessCandidateStarterUserAddedEvent)event;
        ProcessCandidateStarterUser processCandidateStarterUser = (ProcessCandidateStarterUser)processCandidateStarterUserAddedEvent.getEntity();
        ProcessCandidateStarterUserEntity entity = new ProcessCandidateStarterUserEntity(processCandidateStarterUser.getProcessDefinitionId(), processCandidateStarterUser.getUserId());
        try {
            if (!this.candidateStarterEntityAlreadyExists(entity)) {
                this.entityManager.persist((Object)entity);
            }
        }
        catch (Exception cause) {
            throw new QueryException("Error handling ProcessCandidateStarterUserAddedEvent[" + String.valueOf(event) + "]", (Throwable)cause);
        }
    }

    @Override
    public String getHandledEvent() {
        return ProcessCandidateStarterUserEvent.ProcessCandidateStarterUserEvents.PROCESS_CANDIDATE_STARTER_USER_ADDED.name();
    }

    private boolean candidateStarterEntityAlreadyExists(ProcessCandidateStarterUserEntity entity) {
        return this.entityManager.find(ProcessCandidateStarterUserEntity.class, (Object)new ProcessCandidateStarterUserId(entity.getProcessDefinitionId(), entity.getUserId())) != null;
    }
}

