/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.model.events.ProcessRuntimeEvent;
import org.activiti.api.task.model.Task;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessCompletedEvent;
import org.activiti.cloud.api.task.model.impl.CloudTaskImpl;
import org.activiti.cloud.api.task.model.impl.events.CloudTaskCancelledEventImpl;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.events.handlers.TaskCancelledEventHandler;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.QueryException;
import org.activiti.cloud.services.query.model.TaskEntity;

public class ProcessCompletedEventHandler
implements QueryEventHandler {
    private final EntityManager entityManager;
    private final TaskCancelledEventHandler taskCancelledEventHandler;

    public ProcessCompletedEventHandler(EntityManager entityManager, TaskCancelledEventHandler taskCancelledEventHandler) {
        this.entityManager = entityManager;
        this.taskCancelledEventHandler = taskCancelledEventHandler;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudProcessCompletedEvent completedEvent = (CloudProcessCompletedEvent)event;
        String processInstanceId = ((ProcessInstance)completedEvent.getEntity()).getId();
        Optional<ProcessInstanceEntity> findResult = Optional.ofNullable((ProcessInstanceEntity)this.entityManager.find(ProcessInstanceEntity.class, (Object)processInstanceId));
        if (!findResult.isPresent()) {
            throw new QueryException("Unable to find process instance with the given id: " + processInstanceId);
        }
        ProcessInstanceEntity processInstanceEntity = findResult.get();
        processInstanceEntity.setStatus(ProcessInstance.ProcessInstanceStatus.COMPLETED);
        processInstanceEntity.setLastModified(new Date(completedEvent.getTimestamp()));
        processInstanceEntity.setCompletedDate(new Date(completedEvent.getTimestamp()));
        this.entityManager.persist((Object)processInstanceEntity);
        this.callCancelledEventHandlerToCancelRemainingTasks(processInstanceEntity);
    }

    private void callCancelledEventHandlerToCancelRemainingTasks(ProcessInstanceEntity processInstanceEntity) {
        Predicate<TaskEntity> cancellableTasks = task -> Task.TaskStatus.ASSIGNED.equals((Object)task.getStatus()) || Task.TaskStatus.CREATED.equals((Object)task.getStatus());
        Stream.ofNullable(processInstanceEntity.getTasks()).flatMap(Collection::stream).filter(cancellableTasks).map(task -> {
            CloudTaskImpl cloudTask = new CloudTaskImpl();
            cloudTask.setId(task.getId());
            return new CloudTaskCancelledEventImpl((Task)cloudTask);
        }).forEach(this.taskCancelledEventHandler::handle);
    }

    @Override
    public String getHandledEvent() {
        return ProcessRuntimeEvent.ProcessEvents.PROCESS_COMPLETED.name();
    }
}

