/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import org.activiti.cloud.services.query.events.handlers.EntityManagerFinder;
import org.activiti.cloud.services.query.model.QueryException;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.model.TaskVariableEntity;

public class TaskVariableUpdater {
    private final EntityManager entityManager;
    private final EntityManagerFinder entityManagerFinder;

    public TaskVariableUpdater(EntityManager entityManager, EntityManagerFinder entityManagerFinder) {
        this.entityManager = entityManager;
        this.entityManagerFinder = entityManagerFinder;
    }

    public void update(TaskVariableEntity updatedVariableEntity, String notFoundMessage) {
        String taskId = updatedVariableEntity.getTaskId();
        TaskEntity taskEntity = this.entityManagerFinder.findTaskWithVariables(taskId).orElseThrow(() -> new QueryException("Task instance id " + taskId + " not found!"));
        taskEntity.getVariable(updatedVariableEntity.getName()).ifPresentOrElse(variableEntity -> {
            variableEntity.setLastUpdatedTime(updatedVariableEntity.getLastUpdatedTime());
            variableEntity.setType(updatedVariableEntity.getType());
            variableEntity.setValue(updatedVariableEntity.getValue());
            this.entityManager.merge(variableEntity);
        }, () -> {
            throw new QueryException(notFoundMessage);
        });
    }
}

