/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.AttributeConverter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.activiti.cloud.services.query.model.QueryException;

public class ListOfStackTraceElementsJsonConverter
implements AttributeConverter<List<StackTraceElement>, String> {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public ListOfStackTraceElementsJsonConverter() {
    }

    public ListOfStackTraceElementsJsonConverter(ObjectMapper objectMapper) {
        ListOfStackTraceElementsJsonConverter.objectMapper = objectMapper;
    }

    public String convertToDatabaseColumn(List<StackTraceElement> variableValue) {
        try {
            return objectMapper.writeValueAsString(variableValue);
        }
        catch (JsonProcessingException e) {
            throw new QueryException("Unable to serialize list of StackTraceElements", e);
        }
    }

    public List<StackTraceElement> convertToEntityAttribute(String dbData) {
        try {
            if (dbData != null && dbData.length() > 0) {
                return (List)objectMapper.readValue(dbData, (TypeReference)new TypeReference<List<StackTraceElement>>(this){
                    {
                        Objects.requireNonNull(this$0);
                    }
                });
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new QueryException("Unable to deserialize list of StackTraceElements", e);
        }
    }
}

