/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.persistence.AttributeConverter;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.activiti.cloud.services.query.model.QueryException;

public class MapOfStringObjectJsonConverter
implements AttributeConverter<Map<String, Object>, String> {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public MapOfStringObjectJsonConverter() {
        objectMapper.registerModule((Module)new JavaTimeModule());
    }

    public String convertToDatabaseColumn(Map<String, Object> variableValue) {
        try {
            return objectMapper.writeValueAsString(variableValue);
        }
        catch (JsonProcessingException e) {
            throw new QueryException("Unable to serialize list of map of string objects", e);
        }
    }

    public Map<String, Object> convertToEntityAttribute(String dbData) {
        try {
            if (dbData != null && dbData.length() > 0) {
                return (Map)objectMapper.readValue(dbData, (TypeReference)new TypeReference<Map<String, Object>>(this){
                    {
                        Objects.requireNonNull(this$0);
                    }
                });
            }
            return Collections.emptyMap();
        }
        catch (IOException e) {
            throw new QueryException("Unable to deserialize map of string objects", e);
        }
    }
}

