/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import jakarta.persistence.EntityNotFoundException;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.process.model.CloudIntegrationContext;
import org.activiti.cloud.services.query.app.repository.IntegrationContextRepository;
import org.activiti.cloud.services.query.model.IntegrationContextEntity;
import org.activiti.cloud.services.query.rest.assembler.IntegrationContextRepresentationModelAssembler;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/v1/service-tasks"}, produces={"application/hal+json", "application/json"})
public class ServiceTaskIntegrationContextAdminController {
    private final IntegrationContextRepository repository;
    private final IntegrationContextRepresentationModelAssembler representationModelAssembler;
    private final AlfrescoPagedModelAssembler<IntegrationContextEntity> pagedCollectionModelAssembler;

    public ServiceTaskIntegrationContextAdminController(IntegrationContextRepository repository, IntegrationContextRepresentationModelAssembler representationModelAssembler, AlfrescoPagedModelAssembler<IntegrationContextEntity> pagedCollectionModelAssembler) {
        this.repository = repository;
        this.representationModelAssembler = representationModelAssembler;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
    }

    @RequestMapping(value={"/{serviceTaskId}/integration-context"}, method={RequestMethod.GET})
    public EntityModel<CloudIntegrationContext> findByServiceTaskId(@PathVariable String serviceTaskId) {
        String[] split = serviceTaskId.trim().split(":");
        Page page = this.repository.findByProcessInstanceIdAndClientIdAndExecutionId(split[0], split[1], split[2], (Pageable)PageRequest.of((int)0, (int)1, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"requestDate"})));
        if (page.hasContent()) {
            return this.representationModelAssembler.toModel((IntegrationContextEntity)page.getContent().getFirst());
        }
        throw new EntityNotFoundException("Unable to find integration context entity for the given id:'" + serviceTaskId + "'");
    }

    @RequestMapping(value={"/{serviceTaskId}/integration-contexts"}, method={RequestMethod.GET})
    public PagedModel<EntityModel<CloudIntegrationContext>> findAllByServiceTaskId(@PathVariable String serviceTaskId, Pageable pageable) {
        String[] split = serviceTaskId.trim().split(":");
        return this.pagedCollectionModelAssembler.toModel(pageable, this.repository.findByProcessInstanceIdAndClientIdAndExecutionId(split[0], split[1], split[2], pageable), (RepresentationModelAssembler)this.representationModelAssembler);
    }
}

