/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.activiti.cloud.api.model.shared.impl.CloudVariableInstanceImpl;
import org.activiti.cloud.api.process.model.impl.CloudProcessDefinitionImpl;
import org.activiti.cloud.api.process.model.impl.CloudProcessInstanceImpl;
import org.activiti.cloud.api.task.model.impl.CloudTaskImpl;
import org.springframework.core.annotation.Order;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.LinkRelationProvider;

@Order(value=-2147483648)
public class RuntimeBundleLinkRelationProvider
implements LinkRelationProvider {
    private Map<Class<?>, ResourceRelationDescriptor> resourceRelationDescriptors = new HashMap();

    public RuntimeBundleLinkRelationProvider() {
        this.resourceRelationDescriptors.put(CloudProcessDefinitionImpl.class, new ResourceRelationDescriptor(this, "processDefinition", "processDefinitions"));
        this.resourceRelationDescriptors.put(CloudProcessInstanceImpl.class, new ResourceRelationDescriptor(this, "processInstance", "processInstances"));
        this.resourceRelationDescriptors.put(CloudTaskImpl.class, new ResourceRelationDescriptor(this, "task", "tasks"));
        this.resourceRelationDescriptors.put(CloudVariableInstanceImpl.class, new ResourceRelationDescriptor(this, "variable", "variables"));
    }

    public LinkRelation getItemResourceRelFor(Class<?> aClass) {
        return this.resourceRelationDescriptors.get(aClass).getItemResourceRel();
    }

    public LinkRelation getCollectionResourceRelFor(Class<?> aClass) {
        return this.resourceRelationDescriptors.get(aClass).getCollectionResourceRel();
    }

    public boolean supports(LinkRelationProvider.LookupContext delimiter) {
        return this.resourceRelationDescriptors.containsKey(delimiter.getType());
    }

    class ResourceRelationDescriptor {
        private LinkRelation itemResourceRel;
        private LinkRelation collectionResourceRel;

        public ResourceRelationDescriptor(RuntimeBundleLinkRelationProvider this$0, String itemResourceRel, String collectionResourceRel) {
            Objects.requireNonNull(this$0);
            this.itemResourceRel = LinkRelation.of((String)itemResourceRel);
            this.collectionResourceRel = LinkRelation.of((String)collectionResourceRel);
        }

        public LinkRelation getItemResourceRel() {
            return this.itemResourceRel;
        }

        public LinkRelation getCollectionResourceRel() {
            return this.collectionResourceRel;
        }
    }
}

