/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.assemblers;

import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.cloud.api.model.shared.CloudVariableInstance;
import org.activiti.cloud.services.rest.assemblers.ToCloudVariableInstanceConverter;
import org.activiti.cloud.services.rest.controllers.HomeControllerImpl;
import org.activiti.cloud.services.rest.controllers.ProcessInstanceControllerImpl;
import org.activiti.cloud.services.rest.controllers.ProcessInstanceVariableControllerImpl;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;

public class ProcessInstanceVariableRepresentationModelAssembler
implements RepresentationModelAssembler<VariableInstance, EntityModel<CloudVariableInstance>> {
    private ToCloudVariableInstanceConverter converter;

    public ProcessInstanceVariableRepresentationModelAssembler(ToCloudVariableInstanceConverter converter) {
        this.converter = converter;
    }

    public EntityModel<CloudVariableInstance> toModel(VariableInstance variableInstance) {
        CloudVariableInstance cloudVariableInstance = this.converter.from(variableInstance);
        Link processVariables = WebMvcLinkBuilder.linkTo(((ProcessInstanceVariableControllerImpl)WebMvcLinkBuilder.methodOn(ProcessInstanceVariableControllerImpl.class, (Object[])new Object[0])).getVariables(cloudVariableInstance.getProcessInstanceId())).withRel("processVariables");
        Link processInstance = WebMvcLinkBuilder.linkTo(((ProcessInstanceControllerImpl)WebMvcLinkBuilder.methodOn(ProcessInstanceControllerImpl.class, (Object[])new Object[0])).getProcessInstanceById(cloudVariableInstance.getProcessInstanceId())).withRel("processInstance");
        Link homeLink = WebMvcLinkBuilder.linkTo(HomeControllerImpl.class).withRel("home");
        return EntityModel.of((Object)cloudVariableInstance, (Link[])new Link[]{processVariables, processInstance, homeLink});
    }
}

