/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.test.asserts;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.javacrumbs.jsonunit.assertj.JsonAssert;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.activiti.cloud.services.common.file.FileContent;
import org.activiti.cloud.services.common.zip.ZipStream;
import org.assertj.core.api.Assertions;

public class AssertZipContent {
    private static final Consumer<JsonAssert.ConfigurableJsonAssert> ACCEPT_ANY_JSON = json -> {};
    private final String name;
    private final String contentType;
    private final List<String> entries = new ArrayList<String>();
    private final Map<String, byte[]> contentMap = new HashMap<String, byte[]>();

    public AssertZipContent(FileContent fileContent) throws IOException {
        this.name = fileContent.getFilename();
        this.contentType = fileContent.getContentType();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContent.getFileContent());){
            ZipStream.of((InputStream)inputStream).forEach(zipEntry -> {
                this.entries.add(zipEntry.getName());
                zipEntry.getContent().ifPresent(bytes -> this.contentMap.put(zipEntry.getName(), (byte[])bytes));
            });
        }
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public List<String> getEntries() {
        return this.entries;
    }

    public Map<String, byte[]> getContentMap() {
        return this.contentMap;
    }

    public AssertZipContent hasEntries(String ... entries) {
        Assertions.assertThat(this.getEntries()).containsExactlyInAnyOrder((Object[])entries);
        return this;
    }

    public AssertZipContent hasName(String name) {
        Assertions.assertThat((String)this.getName()).isEqualTo(name);
        return this;
    }

    public AssertZipContent hasContent(String entry, byte[] expectedContent) {
        this.hasContent(entry, new String(expectedContent));
        return this;
    }

    public AssertZipContent hasContent(String entry, String expectedContent) {
        this.hasContentSatisfying(entry, actualContent -> Assertions.assertThat((String)actualContent).isEqualTo(expectedContent));
        return this;
    }

    public AssertZipContent hasContentSatisfying(String entry, Consumer<String> requirement) {
        Assertions.assertThat(this.zipContent(entry)).hasValueSatisfying(requirement);
        return this;
    }

    public AssertZipContent hasJsonContent(String entry) {
        return this.hasJsonContentSatisfying(entry, ACCEPT_ANY_JSON);
    }

    public AssertZipContent hasJsonContentSatisfying(String entry, Consumer<JsonAssert.ConfigurableJsonAssert> requirement) {
        Assertions.assertThat(this.zipContent(entry)).map(AssertZipContent::toJsonAssert).hasValueSatisfying(requirement);
        return this;
    }

    private Optional<String> zipContent(String entry) {
        return Optional.ofNullable(entry).map(this.contentMap::get).map(String::new);
    }

    private static JsonAssert.ConfigurableJsonAssert toJsonAssert(String json) {
        return JsonAssertions.assertThatJson((Object)json);
    }
}

