/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.starter.query.configuration;

import org.activiti.cloud.common.swagger.springdoc.SwaggerDocUtils;
import org.activiti.cloud.services.query.rest.VariableSearch;
import org.activiti.cloud.starter.query.configuration.VariableSearchWrapperMixin;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class QuerySwaggerConfig
implements InitializingBean {
    @Bean
    @ConditionalOnMissingBean(name={"queryApi"})
    public GroupedOpenApi queryApi(@Value(value="${activiti.cloud.swagger.query-base-path:}") String querySwaggerBasePath) {
        return GroupedOpenApi.builder().group("Query").packagesToScan(new String[]{"org.activiti.cloud.services.query.rest"}).addOpenApiCustomizer(openApi -> openApi.addExtension("x-service-url-prefix", (Object)querySwaggerBasePath)).build();
    }

    public void afterPropertiesSet() throws Exception {
        SwaggerDocUtils.replaceParameterObjectWithClass(VariableSearch.class, VariableSearchWrapperMixin.class);
    }
}

