/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.registry;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.transform.base.CustomTransformer;
import org.alfresco.transform.base.registry.CustomTransformers;
import org.alfresco.transform.base.registry.LocalTransformConfigSource;
import org.alfresco.transform.base.registry.TransformConfigSource;
import org.alfresco.transform.config.CoreVersionDecorator;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.TransformOptionGroup;
import org.alfresco.transform.config.TransformOptionValue;
import org.alfresco.transform.config.Transformer;
import org.alfresco.transform.registry.AbstractTransformRegistry;
import org.alfresco.transform.registry.CombinedTransformConfig;
import org.alfresco.transform.registry.Origin;
import org.alfresco.transform.registry.TransformCache;
import org.alfresco.transform.registry.TransformerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
public class TransformRegistry
extends AbstractTransformRegistry {
    private static final Logger logger = LoggerFactory.getLogger(TransformRegistry.class);
    @Autowired
    private String coreVersion;
    @Autowired
    private List<TransformConfigSource> transformConfigSources;
    @Value(value="${container.isTRouter}")
    private boolean isTRouter;
    private final AtomicBoolean isRecoveryModeOn = new AtomicBoolean(true);
    private List<CustomTransformer> customTransformerList;
    private int previousLogMessageHashCode;
    private Data data = new Data();
    private final ReadWriteLock configRefreshLock = new ReentrantReadWriteLock();

    @EventListener(value={ContextRefreshedEvent.class})
    public void handleContextRefreshedEvent(ContextRefreshedEvent event) {
        ApplicationContext context = event.getApplicationContext();
        ((TransformRegistry)((Object)context.getBean(TransformRegistry.class))).initRegistryOnAppStartup(event);
    }

    @Async
    void initRegistryOnAppStartup(ContextRefreshedEvent event) {
        this.customTransformerList = ((CustomTransformers)event.getApplicationContext().getBean(CustomTransformers.class)).toList();
        this.retrieveConfig();
    }

    @Scheduled(cron="${transform.engine.config.cron}")
    public void retrieveEngineConfigs() {
        logger.trace("Refresh TransformRegistry.");
        this.retrieveConfig();
    }

    @Scheduled(initialDelayString="#{${transform.engine.config.retry.timeout} * 1000}", fixedDelayString="#{${transform.engine.config.retry.timeout} * 1000}")
    public void retrieveEngineConfigsAfterFailure() {
        if (this.isRecoveryModeOn.get()) {
            logger.trace("Recovery mode, attempting to retrieve configs for all registered T-Engines.");
            this.retrieveConfig();
        }
    }

    void retrieveConfig() {
        CombinedTransformConfig combinedTransformConfig = new CombinedTransformConfig();
        TreeMap<String, LocalTransformConfigSource> availableTransformers = new TreeMap<String, LocalTransformConfigSource>();
        logger.debug("Retrieving available TransformConfig.");
        for (TransformConfigSource source2 : this.transformConfigSources) {
            try {
                String sortOnName = source2.getSortOnName();
                TransformConfig transformConfig = source2.getTransformConfig();
                availableTransformers.put(sortOnName, new LocalTransformConfigSource(transformConfig, sortOnName, source2.getReadFrom(), source2.getBaseUrl()));
            }
            catch (IllegalStateException e) {
                if (this.isRecoveryModeOn.getAcquire()) {
                    logger.trace("Failed to retrieved TransformConfig during recovery mode. {}", (Object)e.getMessage());
                    continue;
                }
                logger.warn("Failed to retrieved TransformConfig during refreshment. Stops refreshing TransformRegistry. {}", (Object)e.getMessage());
                return;
            }
        }
        if (this.transformConfigSources.size() == availableTransformers.size() && this.isRecoveryModeOn.compareAndExchange(true, false)) {
            logger.trace("All TransformConfigSources have been retrieved, turning off recovery mode.");
        }
        logger.debug("Creating CombinedTransformConfig.");
        availableTransformers.values().forEach(source -> {
            TransformConfig transformConfig = source.getTransformConfig();
            CoreVersionDecorator.setCoreVersionOnSingleStepTransformers((TransformConfig)transformConfig, (String)this.coreVersion);
            combinedTransformConfig.addTransformConfig(transformConfig, source.getReadFrom(), source.getBaseUrl(), (AbstractTransformRegistry)this);
        });
        TransformConfig uncombinedTransformConfig = combinedTransformConfig.buildTransformConfig();
        combinedTransformConfig.combineTransformerConfig((AbstractTransformRegistry)this);
        TransformConfig transformConfig = combinedTransformConfig.buildTransformConfig();
        Map transformerByNameMap = combinedTransformConfig.getTransformerByNameMap();
        this.concurrentUpdate(combinedTransformConfig, uncombinedTransformConfig, transformConfig, transformerByNameMap);
        this.logTransformers(uncombinedTransformConfig, transformerByNameMap);
    }

    private void logTransformers(TransformConfig uncombinedTransformConfig, Map<String, Origin<Transformer>> transformerByNameMap) {
        if (logger.isInfoEnabled()) {
            HashSet customTransformerNames = new HashSet(this.customTransformerList == null ? Collections.emptySet() : (Collection)this.customTransformerList.stream().map(CustomTransformer::getTransformerName).collect(Collectors.toSet()));
            List nonNullTransformerNames = uncombinedTransformConfig.getTransformers().stream().map(Transformer::getTransformerName).filter(Objects::nonNull).collect(Collectors.toList());
            ArrayList<CallSite> logMessages = new ArrayList<CallSite>();
            if (!nonNullTransformerNames.isEmpty()) {
                int logMessageHashCode;
                logMessages.add((CallSite)((Object)("Transformers (" + nonNullTransformerNames.size() + ") Transforms (" + this.getData().getTransformCount() + "):")));
                nonNullTransformerNames.stream().sorted(String.CASE_INSENSITIVE_ORDER).map(name -> {
                    Origin transformerOrigin = (Origin)transformerByNameMap.get(name);
                    String message = "  " + name + (transformerOrigin == null ? " -- unavailable: see previous messages" : (this.isTRouter ? "" : (TransformerType.valueOf((Transformer)((Transformer)transformerOrigin.get())) == TransformerType.PIPELINE_TRANSFORMER ? " -- unavailable: pipeline only available via t-router" : (TransformerType.valueOf((Transformer)((Transformer)transformerOrigin.get())) == TransformerType.FAILOVER_TRANSFORMER ? " -- unavailable: failover only available via t-router" : (!customTransformerNames.contains(name) ? " -- missing: CustomTransformer" : "")))));
                    customTransformerNames.remove(name);
                    return message;
                }).forEach(logMessages::add);
                List unusedCustomTransformNames = customTransformerNames.stream().filter(Objects::nonNull).sorted().collect(Collectors.toList());
                if (!unusedCustomTransformNames.isEmpty()) {
                    logMessages.add((CallSite)((Object)("Unused CustomTransformers (" + unusedCustomTransformNames.size() + ") - name is not in the transform config:")));
                    unusedCustomTransformNames.stream().map(name -> "  " + name).forEach(logMessages::add);
                }
                if (this.previousLogMessageHashCode != (logMessageHashCode = logMessages.hashCode())) {
                    this.previousLogMessageHashCode = logMessageHashCode;
                    logMessages.stream().forEach(arg_0 -> ((Logger)logger).info(arg_0));
                } else {
                    logger.debug("Config unchanged");
                }
            }
        }
    }

    public TransformConfig getTransformConfig() {
        Data data = this.getData();
        return this.isTRouter ? data.getTransformConfig() : data.getUncombinedTransformConfig();
    }

    public boolean isReadyForTransformRequests() {
        return this.getData().getTransforms().size() > 0;
    }

    public boolean isRecoveryModeOn() {
        return this.isRecoveryModeOn.getAcquire();
    }

    public Data getData() {
        return this.concurrentRead(() -> this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concurrentUpdate(CombinedTransformConfig combinedTransformConfig, TransformConfig uncombinedTransformConfig, TransformConfig transformConfig, Map<String, Origin<Transformer>> transformerByNameMap) {
        this.configRefreshLock.writeLock().lock();
        try {
            this.data = new Data();
            this.data.setTransformConfig(transformConfig);
            this.data.setUncombinedTransformConfig(uncombinedTransformConfig);
            this.data.setTransformerByNameMap(transformerByNameMap);
            combinedTransformConfig.registerCombinedTransformers((AbstractTransformRegistry)this);
        }
        finally {
            this.configRefreshLock.writeLock().unlock();
        }
    }

    private <T> T concurrentRead(Supplier<T> s) {
        this.configRefreshLock.readLock().lock();
        try {
            T t = s.get();
            return t;
        }
        finally {
            this.configRefreshLock.readLock().unlock();
        }
    }

    protected void logError(String msg) {
        logger.error(msg);
    }

    protected void logWarn(String msg) {
        logger.warn(msg);
    }

    public Transformer getTransformer(String sourceMediaType, Long fileSizeBytes, String targetMediaType, Map<String, String> transformOptions) {
        return this.concurrentRead(() -> {
            long fileSize = fileSizeBytes == null ? 0L : fileSizeBytes;
            String transformerName = this.findTransformerName(sourceMediaType, fileSize, targetMediaType, transformOptions, null);
            return this.getTransformer(transformerName);
        });
    }

    public Transformer getTransformer(String transformerName) {
        return this.getTransformer(this.getData(), transformerName);
    }

    private Transformer getTransformer(Data data, String transformerName) {
        Origin<Transformer> transformerOrigin = data.getTransformerByNameMap().get(transformerName);
        return transformerOrigin == null ? null : (Transformer)transformerOrigin.get();
    }

    public boolean checkSourceSize(String transformerName, String sourceMediaType, Long sourceSize, String targetMediaType) {
        return Optional.ofNullable(this.getTransformer(transformerName)).map(transformer -> transformer.getSupportedSourceAndTargetList().stream().filter(supported -> supported.getSourceMediaType().equals(sourceMediaType) && supported.getTargetMediaType().equals(targetMediaType)).findFirst().map(supported -> supported.getMaxSourceSizeBytes() == -1L || supported.getMaxSourceSizeBytes() >= sourceSize).orElse(false)).orElse(false);
    }

    public String getEngineName(String transformerName) {
        return this.getData().getTransformerByNameMap().get(transformerName).getReadFrom();
    }

    public Map<String, String> filterOptions(String transformerName, Map<String, String> options) {
        Data data = this.getData();
        Map configOptions = data.getTransformConfig().getTransformOptions();
        Transformer transformer = this.getTransformer(data, transformerName);
        if (Objects.isNull(transformer) || CollectionUtils.isEmpty(options) || CollectionUtils.isEmpty((Map)configOptions)) {
            return Collections.emptyMap();
        }
        Set knownOptions = transformer.getTransformOptions().stream().flatMap(name -> ((Set)configOptions.get(name)).stream()).filter(Objects::nonNull).flatMap(TransformRegistry::retrieveOptionsStrings).collect(Collectors.toUnmodifiableSet());
        if (CollectionUtils.isEmpty(knownOptions)) {
            return Collections.emptyMap();
        }
        return options.entrySet().stream().filter(e -> knownOptions.contains(e.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Stream<String> retrieveOptionsStrings(TransformOption option) {
        if (option instanceof TransformOptionGroup) {
            return ((TransformOptionGroup)option).getTransformOptions().stream().flatMap(TransformRegistry::retrieveOptionsStrings);
        }
        return Stream.of(((TransformOptionValue)option).getName());
    }

    private static class Data
    extends TransformCache {
        private TransformConfig transformConfig;
        private TransformConfig uncombinedTransformConfig;
        private Map<String, Origin<Transformer>> transformerByNameMap;

        private Data() {
        }

        public TransformConfig getTransformConfig() {
            return this.transformConfig;
        }

        public void setTransformConfig(TransformConfig transformConfig) {
            this.transformConfig = transformConfig;
        }

        public TransformConfig getUncombinedTransformConfig() {
            return this.uncombinedTransformConfig;
        }

        public void setUncombinedTransformConfig(TransformConfig uncombinedTransformConfig) {
            this.uncombinedTransformConfig = uncombinedTransformConfig;
        }

        public Map<String, Origin<Transformer>> getTransformerByNameMap() {
            return this.transformerByNameMap;
        }

        public void setTransformerByNameMap(Map<String, Origin<Transformer>> transformerByNameMap) {
            this.transformerByNameMap = transformerByNameMap;
        }

        public int getTransformCount() {
            return this.transformCount;
        }
    }
}

