/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.test.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.LoggerFactory;

public class LoggingUtils {
    public static ListAppender<ILoggingEvent> createLogsListAppender(Class<?> classToTrack, Class<?> ... classesToTrack) {
        return LoggingUtils.createLogsAppender(ListAppender::new, (Class[])Stream.concat(Stream.of(classToTrack), Arrays.stream(classesToTrack)).toArray(Class[]::new));
    }

    private static <T extends Appender<ILoggingEvent>> T createLogsAppender(Supplier<T> appenderSupplier, Class<?> ... classesToTrack) {
        Appender appender = (Appender)appenderSupplier.get();
        Arrays.stream(classesToTrack).forEach(classToTrack -> LoggingUtils.addAppenderForLogger((Appender<ILoggingEvent>)appender, classToTrack));
        appender.start();
        return (T)appender;
    }

    private static void addAppenderForLogger(Appender<ILoggingEvent> appender, Class<?> classToTrack) {
        Logger logger = (Logger)LoggerFactory.getLogger(classToTrack);
        logger.addAppender(appender);
        logger.setLevel(Level.DEBUG);
    }

    @Generated
    private LoggingUtils() {
    }
}

