/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.test.util;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryUtils.class);
    private static final int MAX_ATTEMPTS = 15;
    private static final int INITIAL_DELAY_MS = 100;

    public static void retryWithBackoff(ErrorCatchingRunnable runnable) {
        RetryUtils.retryWithBackoff(() -> {
            runnable.run();
            return null;
        });
    }

    public static void retryWithBackoff(ErrorCatchingRunnable runnable, int delayMs) {
        RetryUtils.retryWithBackoff(runnable, 15, delayMs);
    }

    public static void retryWithBackoff(ErrorCatchingRunnable runnable, int maxAttempts, int delayMs) {
        RetryUtils.retryWithBackoff(() -> {
            runnable.run();
            return null;
        }, maxAttempts, delayMs);
    }

    public static <T> T retryWithBackoff(Supplier<T> supplier) {
        return RetryUtils.retryWithBackoff(supplier, 15, 100);
    }

    public static <T> T retryWithBackoff(Supplier<T> supplier, int maxAttempts, int delayMs) {
        int attempt = 0;
        while (true) {
            try {
                return supplier.get();
            }
            catch (AssertionError e) {
                if (++attempt >= maxAttempts) {
                    log.atDebug().log("Attempt {} failed", (Object)attempt);
                    throw e;
                }
                log.atDebug().log("Attempt {} failed, retrying after {}ms", (Object)attempt, (Object)delayMs);
                TimeUnit.MILLISECONDS.sleep(delayMs);
                continue;
            }
            break;
        }
    }

    @Generated
    private RetryUtils() {
    }

    public static interface ErrorCatchingRunnable
    extends Runnable {
        public void runUnsafe() throws Exception;

        @Override
        default public void run() {
            this.runUnsafe();
        }
    }
}

