/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.test.docker.repository;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.NonNull;
import org.alfresco.hxi_connector.common.test.docker.repository.AlfrescoRepositoryContainer;
import org.alfresco.hxi_connector.common.test.docker.repository.RepositoryType;
import org.alfresco.hxi_connector.common.test.docker.util.DockerTags;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.images.builder.dockerfile.statement.SingleArgumentStatement;
import org.testcontainers.images.builder.dockerfile.statement.Statement;
import org.testcontainers.utility.DockerImageName;

public class AlfrescoRepositoryExtension
extends ImageFromDockerfile {
    private static final String REPO_JAVA_VERSION = DockerTags.getOrDefault("repository.java.version", "17");
    private static final String LOCAL_IMAGE_DEFAULT = "localhost/alfresco/alfresco-content-repository-extended";
    private static final String JAVA_INSTALL_SCRIPT = "if [[ \"$JAVA_VERSION\" == \"11\" ]]; then\n  ARCH=$(uname -m | sed s/86_//);\n  JAVA_RELEASE=11.0.24_8;\n  curl -fsLo java.tar.gz https://github.com/adoptium/temurin${JAVA_VERSION}-binaries/releases/download/jdk-${JAVA_RELEASE/_/+}/OpenJDK${JAVA_VERSION}U-jre_${ARCH}_linux_hotspot_${JAVA_RELEASE}.tar.gz &&\n  tar xvfz java.tar.gz &&\n  mv jdk-* /usr/lib/jvm/temurin-11-jdk &&\n  update-alternatives --install /usr/bin/java java /usr/lib/jvm/temurin-11-jdk/bin/java 1 &&\n  update-alternatives --remove java $(update-alternatives --display java | head -2 | tail -1 | cut -d \" \" -f6);\nfi\n".replace("\n", " ");
    private static final String JAVA_SWITCH_SCRIPT_NAME = "java-switching-entrypoint.sh";
    private static final String JAVA_SWITCH_SCRIPT_PATH = "/java-switching-entrypoint.sh";
    private static final String JAVA_SWITCH_SCRIPT = "#!/bin/bash -e\n# Switch to Java 11 if it has been installed\n[ -d \"/usr/lib/jvm/temurin-11-jdk\" ] && export JAVA_HOME=/usr/lib/jvm/temurin-11-jdk\nexec \"$@\"\n";

    public AlfrescoRepositoryExtension(@NonNull String extension) {
        this(extension, LOCAL_IMAGE_DEFAULT);
        if (extension == null) {
            throw new NullPointerException("extension is marked non-null but is null");
        }
    }

    public AlfrescoRepositoryExtension(@NonNull String extension, @NonNull String localImageName) {
        this(extension, localImageName, RepositoryType.COMMUNITY);
        if (extension == null) {
            throw new NullPointerException("extension is marked non-null but is null");
        }
        if (localImageName == null) {
            throw new NullPointerException("localImageName is marked non-null but is null");
        }
    }

    public AlfrescoRepositoryExtension(@NonNull String extension, @NonNull String localImageName, RepositoryType repositoryType) {
        this(DockerImageName.parse((String)repositoryType.getImageName()).withTag(AlfrescoRepositoryContainer.REPOSITORY_TAG), extension, localImageName);
        if (extension == null) {
            throw new NullPointerException("extension is marked non-null but is null");
        }
        if (localImageName == null) {
            throw new NullPointerException("localImageName is marked non-null but is null");
        }
    }

    public AlfrescoRepositoryExtension(@NonNull DockerImageName imageToExtend, @NonNull String extension, @NonNull String localImageName) {
        super(localImageName);
        if (imageToExtend == null) {
            throw new NullPointerException("imageToExtend is marked non-null but is null");
        }
        if (extension == null) {
            throw new NullPointerException("extension is marked non-null but is null");
        }
        if (localImageName == null) {
            throw new NullPointerException("localImageName is marked non-null but is null");
        }
        this.createImage(imageToExtend, extension);
    }

    private void createImage(DockerImageName dockerImageName, String extension) {
        Path jarFile = AlfrescoRepositoryExtension.findTargetJar(extension);
        ((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)this.withFileFromPath(jarFile.toString(), jarFile)).withFileFromString(JAVA_SWITCH_SCRIPT_NAME, JAVA_SWITCH_SCRIPT)).withDockerfileFromBuilder(builder -> ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from(dockerImageName.toString())).user("root")).copy(jarFile.toString().replace("\\", "/"), "/usr/local/tomcat/webapps/alfresco/WEB-INF/lib/")).withStatement((Statement)new SingleArgumentStatement("ARG", "JAVA_VERSION"))).run(JAVA_INSTALL_SCRIPT)).copy(JAVA_SWITCH_SCRIPT_NAME, "/")).run("chmod +x /java-switching-entrypoint.sh")).run("chown -R -h alfresco /usr/local/tomcat")).user("alfresco")).entryPoint(new String[]{JAVA_SWITCH_SCRIPT_PATH, "catalina.sh", "run", "-security"})).build())).withBuildArg("JAVA_VERSION", REPO_JAVA_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path findTargetJar(String name) {
        Path path;
        block6: {
            String path2 = "target";
            String extension = "jar";
            Stream<Path> files = Files.list(Paths.get(path2, new String[0]));
            try {
                String extensionFileName = "%s-%s.%s".formatted(name, DockerTags.getHxiConnectorTag(), extension);
                path = files.filter(AlfrescoRepositoryExtension.nameEquals(extensionFileName)).findFirst().orElseThrow(() -> new IllegalStateException("%s file with name: '%s' not found in directory: '%s/'".formatted(extension.toUpperCase(Locale.ENGLISH), extensionFileName, path2)));
                if (Collections.singletonList(files).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(files).get(0) != null) {
                    files.close();
                }
                throw throwable;
            }
            files.close();
        }
        return path;
    }

    private static Predicate<Path> nameEquals(String name) {
        return path -> path != null && path.getFileName().toString().equalsIgnoreCase(name);
    }
}

