/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.test.docker.util;

import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import lombok.Generated;
import org.alfresco.hxi_connector.common.test.docker.repository.AlfrescoRepositoryContainer;
import org.alfresco.hxi_connector.common.test.docker.repository.AlfrescoRepositoryExtension;
import org.alfresco.hxi_connector.common.test.docker.repository.RepositoryType;
import org.alfresco.hxi_connector.common.test.docker.util.DockerTags;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.wiremock.integrations.testcontainers.WireMockContainer;

public class DockerContainers {
    private static final Pattern SPECIAL_REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");
    private static final String REPOSITORY_EXTENSION = DockerTags.getOrDefault("repository.extension", "alfresco-hxinsight-connector-hxinsight-extension");
    private static final String EXTENDED_REPOSITORY_LOCAL_NAME = "localhost/alfresco/alfresco-content-repository-hxinsight-extension";
    private static final String POSTGRES_IMAGE = "postgres";
    private static final String POSTGRES_TAG = DockerTags.getPostgresTag();
    private static final String ACTIVE_MQ_IMAGE = "quay.io/alfresco/alfresco-activemq";
    private static final String ACTIVE_MQ_TAG = DockerTags.getActiveMqTag();
    private static final String WIREMOCK_IMAGE = "wiremock/wiremock";
    private static final String WIREMOCK_TAG = DockerTags.getWiremockTag();
    private static final String LOCALSTACK_IMAGE = "localstack/localstack";
    private static final String LOCALSTACK_TAG = DockerTags.getLocalStackTag();
    private static final String TRANSFORM_ROUTER_IMAGE = "quay.io/alfresco/alfresco-transform-router";
    private static final String TRANSFORM_ROUTER_TAG = DockerTags.getTransformRouterTag();
    private static final String TRANSFORM_CORE_AIO_IMAGE = "quay.io/alfresco/alfresco-transform-core-aio";
    private static final String TRANSFORM_CORE_AIO_TAG = DockerTags.getTransformCoreAioTag();
    private static final String SFS_IMAGE = "quay.io/alfresco/alfresco-shared-file-store";
    private static final String SFS_TAG = DockerTags.getSfsTag();
    private static final String BULK_INGESTER_IMAGE = "quay.io/alfresco/alfresco-hxinsight-connector-bulk-ingester";
    private static final String LIVE_INGESTER_IMAGE = "quay.io/alfresco/alfresco-hxinsight-connector-live-ingester";
    private static final String HXI_CONNECTOR_TAG = DockerTags.getHxiConnectorTag();
    private static final String PREDICTION_APPLIER_IMAGE = "quay.io/alfresco/alfresco-hxinsight-connector-prediction-applier";
    private static final String DB_USER = "alfresco";
    private static final String DB_PASS = "alfresco";
    private static final String DB_NAME = "alfresco";
    private static final String REPOSITORY_ALIAS = "repository";
    private static final String POSTGRES_ALIAS = "postgres";
    private static final String ACTIVE_MQ_ALIAS = "activemq";
    private static final String TRANSFORM_ROUTER_ALIAS = "transform-router";
    private static final String TRANSFORM_CORE_AIO_ALIAS = "transform-core-aio";
    private static final String SFS_ALIAS = "shared-file-store";
    private static final String BULK_INGESTER_ALIAS = "bulk-ingester";
    private static final String LIVE_INGESTER_ALIAS = "live-ingester";
    private static final String PREDICTION_APPLIER_ALIAS = "prediction-applier";
    private static final String LOCALSTACK_ALIAS = "aws-mock";
    public static final String MINIMAL_REPO_JAVA_OPTS = "-Ddb.driver=org.postgresql.Driver\n-Ddb.username=%s\n-Ddb.password=%s\n-Ddb.url=jdbc:postgresql://%s:5432/%s\n-Dcsrf.filter.enabled=false\n-Dmessaging.broker.url=\"failover:(nio://%s:61616)?timeout=3000&jms.useCompression=true\"\n-Dalfresco.restApi.basicAuthScheme=true\n-Ddeployment.method=DOCKER_COMPOSE\n-Dalfresco.host=alfresco\n-Dalfresco.port=8080\n-Xms1500m -Xmx1500m\n-Dtransform.service.enabled=%s\n";
    public static final String TRANSFORMS_REPO_JAVA_OPTS = "-Dtransform.service.url=http://transform-router:8095\n-Dsfs.url=http://shared-file-store:8099\n-DlocalTransform.core-aio.url=http://transform-core-aio:8090\n-Dalfresco-pdf-renderer.url=http://transform-core-aio:8090\n-Djodconverter.url=http://transform-core-aio:8090\n-Dimg.url=http://transform-core-aio:8090\n-Dtika.url=http://transform-core-aio:8090\n-Dtransform.misc.url=http://transform-core-aio:8090\n";

    public static AlfrescoRepositoryContainer createExtendedRepositoryContainerWithin(Network network) {
        return DockerContainers.createExtendedRepositoryContainerWithin(network, RepositoryType.COMMUNITY);
    }

    public static AlfrescoRepositoryContainer createExtendedRepositoryContainerWithin(Network network, RepositoryType repositoryType) {
        AlfrescoRepositoryContainer.pullRepositoryImage(repositoryType);
        AlfrescoRepositoryContainer repository = (AlfrescoRepositoryContainer)((AlfrescoRepositoryContainer)new AlfrescoRepositoryContainer(new AlfrescoRepositoryExtension(REPOSITORY_EXTENSION, EXTENDED_REPOSITORY_LOCAL_NAME, repositoryType)).waitingFor(Wait.forHttp((String)"/alfresco").forPort(8080).withStartupTimeout(Duration.ofMinutes(5L)))).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)AlfrescoRepositoryContainer.class.getSimpleName())));
        Optional.ofNullable(network).ifPresent(n -> ((AlfrescoRepositoryContainer)repository.withNetwork((Network)n)).withNetworkAliases(new String[]{REPOSITORY_ALIAS}));
        return repository;
    }

    public static String concatJavaOpts(String ... opts) {
        return String.join((CharSequence)" ", opts);
    }

    @NotNull
    public static String getMinimalRepoJavaOpts(PostgreSQLContainer<?> postgresContainer, GenericContainer<?> activemqContainer) {
        return MINIMAL_REPO_JAVA_OPTS.formatted(postgresContainer.getUsername(), postgresContainer.getPassword(), postgresContainer.getNetworkAliases().stream().findFirst().get(), postgresContainer.getDatabaseName(), activemqContainer.getNetworkAliases().stream().findFirst().get(), "false").replace("\n", " ");
    }

    @NotNull
    public static String getRepoJavaOptsWithTransforms(PostgreSQLContainer<?> postgresContainer, GenericContainer<?> activemqContainer) {
        return MINIMAL_REPO_JAVA_OPTS.formatted(postgresContainer.getUsername(), postgresContainer.getPassword(), postgresContainer.getNetworkAliases().stream().findFirst().get(), postgresContainer.getDatabaseName(), activemqContainer.getNetworkAliases().stream().findFirst().get(), "true").replace("\n", " ") + TRANSFORMS_REPO_JAVA_OPTS.replace("\n", " ");
    }

    public static String getHxInsightRepoJavaOpts(WireMockContainer hxInsightMockContainer) {
        String hXIMockAlias = (String)hxInsightMockContainer.getNetworkAliases().stream().findFirst().get();
        return "-Dhxi.discovery.agents-endpoint=http://%s:8080\n-Dhxi.discovery.questions-endpoint=http://%s:8080\n-Dhxi.auth.providers.hyland-experience.token-uri=http://%s:8080/token\n-Dhxi.question.max-context-size-for-question=10\n".formatted(hXIMockAlias, hXIMockAlias, hXIMockAlias).replace("\n", " ");
    }

    public static PostgreSQLContainer<?> createPostgresContainer() {
        return (PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)"postgres").withTag(POSTGRES_TAG)).withUsername("alfresco").withPassword("alfresco").withDatabaseName("alfresco").withExposedPorts(new Integer[]{5432})).withStartupTimeout(Duration.ofMinutes(2L));
    }

    public static PostgreSQLContainer<?> createPostgresContainerWithin(Network network) {
        return (PostgreSQLContainer)((PostgreSQLContainer)DockerContainers.createPostgresContainer().withNetwork(network)).withNetworkAliases(new String[]{"postgres"});
    }

    public static GenericContainer<?> createActiveMqContainer() {
        return new GenericContainer(DockerImageName.parse((String)ACTIVE_MQ_IMAGE).withTag(ACTIVE_MQ_TAG)).withEnv("JAVA_OPTS", "-Xms512m -Xmx1g").withExposedPorts(new Integer[]{61616, 8161, 5672, 61613}).withStartupTimeout(Duration.ofMinutes(2L));
    }

    public static GenericContainer<?> createActiveMqContainerWithin(Network network) {
        return DockerContainers.createActiveMqContainer().withNetwork(network).withNetworkAliases(new String[]{ACTIVE_MQ_ALIAS});
    }

    public static GenericContainer<?> createTransformRouterContainerWithin(Network network) {
        GenericContainer transformRouter = new GenericContainer(DockerImageName.parse((String)TRANSFORM_ROUTER_IMAGE).withTag(TRANSFORM_ROUTER_TAG)).withEnv("JAVA_TOOL_OPTIONS", "-agentlib:jdwp=transport=dt_socket,address=*:5011,server=y,suspend=n").withEnv("JAVA_OPTS", "-Xms256m -Xmx512m").withEnv("ACTIVEMQ_URL", "nio://activemq:61616").withEnv("CORE_AIO_URL", "http://transform-core-aio:8090").withEnv("FILE_STORE_URL", "http://shared-file-store:8099/alfresco/api/-default-/private/sfs/versions/1/file").withExposedPorts(new Integer[]{8095}).waitingFor(Wait.forHttp((String)"/").forPort(8095).withStartupTimeout(Duration.ofMinutes(2L))).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)"TransformRouterContainer")));
        Optional.ofNullable(network).ifPresent(n -> transformRouter.withNetwork(n).withNetworkAliases(new String[]{TRANSFORM_ROUTER_ALIAS}));
        return transformRouter;
    }

    public static GenericContainer<?> createTransformCoreAioContainerWithin(Network network) {
        GenericContainer transformCoreAio = new GenericContainer(DockerImageName.parse((String)TRANSFORM_CORE_AIO_IMAGE).withTag(TRANSFORM_CORE_AIO_TAG)).withEnv("JAVA_TOOL_OPTIONS", "-agentlib:jdwp=transport=dt_socket,address=*:5010,server=y,suspend=n").withEnv("JAVA_OPTS", "-Xms512m -Xmx1024m").withEnv("ACTIVEMQ_URL", "nio://activemq:61616").withEnv("FILE_STORE_URL", "http://shared-file-store:8099/alfresco/api/-default-/private/sfs/versions/1/file").withExposedPorts(new Integer[]{8090}).waitingFor(Wait.forHttp((String)"/").forPort(8090).withStartupTimeout(Duration.ofMinutes(2L))).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)"TransformCoreContainer")));
        Optional.ofNullable(network).ifPresent(n -> transformCoreAio.withNetwork(n).withNetworkAliases(new String[]{TRANSFORM_CORE_AIO_ALIAS}));
        return transformCoreAio;
    }

    public static GenericContainer<?> createSfsContainerWithin(Network network) {
        GenericContainer sfs = new GenericContainer(DockerImageName.parse((String)SFS_IMAGE).withTag(SFS_TAG)).withEnv("JAVA_OPTS", "-Xms256m -Xmx512m").withEnv("SCHEDULER_CONTENT_AGE_MILLIS", "86400000").withEnv("SCHEDULER_CLEANUP_INTERVAL", "86400000").withExposedPorts(new Integer[]{8099}).withStartupTimeout(Duration.ofMinutes(2L));
        Optional.ofNullable(network).ifPresent(n -> sfs.withNetwork(n).withNetworkAliases(new String[]{SFS_ALIAS}));
        return sfs;
    }

    public static GenericContainer<?> createBulkIngesterContainerWithin(PostgreSQLContainer<?> postgresContainer, Network network) {
        GenericContainer bulkIngester = new GenericContainer(DockerImageName.parse((String)BULK_INGESTER_IMAGE).withTag(HXI_CONNECTOR_TAG)).withEnv("JAVA_TOOL_OPTIONS", "-agentlib:jdwp=transport=dt_socket,address=*:5008,server=y,suspend=n").withEnv("LOGGING_LEVEL_ORG_ALFRESCO", "DEBUG").withEnv("SPRING_ACTIVEMQ_BROKERURL", "nio://activemq:61616").withEnv("SPRING_DATASOURCE_URL", "jdbc:postgresql://%s:5432/%s".formatted(postgresContainer.getNetworkAliases().stream().findFirst().get(), postgresContainer.getDatabaseName())).withEnv("SPRING_DATASOURCE_USERNAME", postgresContainer.getUsername()).withEnv("SPRING_DATASOURCE_PASSWORD", postgresContainer.getPassword()).withExposedPorts(new Integer[]{5008}).withStartupTimeout(Duration.ofMinutes(2L)).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Started BulkIngesterApplication.*", (int)1)).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)"BulkIngesterContainer")));
        Optional.ofNullable(network).ifPresent(n -> bulkIngester.withNetwork(n).withNetworkAliases(new String[]{BULK_INGESTER_ALIAS}));
        return bulkIngester;
    }

    public static GenericContainer<?> createLiveIngesterContainerWithin(Network network) {
        GenericContainer liveIngester = new GenericContainer(DockerImageName.parse((String)LIVE_INGESTER_IMAGE).withTag(HXI_CONNECTOR_TAG)).withEnv("JAVA_TOOL_OPTIONS", "-agentlib:jdwp=transport=dt_socket,address=*:5007,server=y,suspend=n").withEnv("LOGGING_LEVEL_ORG_ALFRESCO", "DEBUG").withEnv("SPRING_ACTIVEMQ_BROKERURL", "nio://activemq:61616").withEnv("ALFRESCO_TRANSFORM_SHAREDFILESTORE_BASEURL", "http://shared-file-store:8099").withEnv("ALFRESCO_REPOSITORY_HEALTH_PROBE_INTERVAL_SECONDS", "1").withExposedPorts(new Integer[]{8080, 5007}).waitingFor(Wait.forHttp((String)"/actuator/health/readiness").forPort(8080).withStartupTimeout(Duration.ofMinutes(2L))).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)"LiveIngesterContainer")));
        Optional.ofNullable(network).ifPresent(n -> liveIngester.withNetwork(n).withNetworkAliases(new String[]{LIVE_INGESTER_ALIAS}));
        return liveIngester;
    }

    public static GenericContainer<?> createLiveIngesterContainerForWireMock(WireMockContainer hxInsightMockContainer, Network network) {
        return DockerContainers.createLiveIngesterContainerWithin(network).withEnv("HYLANDEXPERIENCE_INSIGHT_INGESTION_BASEURL", "http://%s:8080".formatted(hxInsightMockContainer.getNetworkAliases().stream().findFirst().get())).withEnv("AUTH_PROVIDERS_HYLANDEXPERIENCE_TOKENURI", "http://%s:8080/token".formatted(hxInsightMockContainer.getNetworkAliases().stream().findFirst().get())).withEnv("AUTH_PROVIDERS_HYLANDEXPERIENCE_CLIENTID", "dummy-client-key").withEnv("AUTH_PROVIDERS_ALFRESCO_USERNAME", "admin").withEnv("AUTH_PROVIDERS_ALFRESCO_PASSWORD", "admin");
    }

    public static GenericContainer<?> createLiveIngesterContainerForWireMock(WireMockContainer hxInsightMockContainer, AlfrescoRepositoryContainer acsContainer, Network network) {
        return DockerContainers.createLiveIngesterContainerForWireMock(hxInsightMockContainer, network).withEnv("ALFRESCO_REPOSITORY_BASE_URL", "http://%s:8080/alfresco".formatted(acsContainer.getNetworkAliases().stream().findFirst().get()));
    }

    public static GenericContainer<?> createPredictionApplierContainerWithin(Network network) {
        GenericContainer predictionApplier = new GenericContainer(DockerImageName.parse((String)PREDICTION_APPLIER_IMAGE).withTag(HXI_CONNECTOR_TAG)).withEnv("JAVA_TOOL_OPTIONS", "-agentlib:jdwp=transport=dt_socket,address=*:5009,server=y,suspend=n").withEnv("LOGGING_LEVEL_ORG_ALFRESCO", "DEBUG").withExposedPorts(new Integer[]{8080, 5009}).waitingFor(Wait.forHttp((String)"/actuator/health/readiness").forPort(8080).withStartupTimeout(Duration.ofMinutes(2L))).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)"PredictionApplierContainer")));
        Optional.ofNullable(network).ifPresent(n -> predictionApplier.withNetwork(n).withNetworkAliases(new String[]{PREDICTION_APPLIER_ALIAS}));
        return predictionApplier;
    }

    public static WireMockContainer createWireMockContainer() {
        return (WireMockContainer)new WireMockContainer(DockerImageName.parse((String)WIREMOCK_IMAGE).withTag(WIREMOCK_TAG)).withEnv("WIREMOCK_OPTIONS", "--verbose");
    }

    public static WireMockContainer createWireMockContainerWithin(Network network) {
        return (WireMockContainer)((WireMockContainer)DockerContainers.createWireMockContainer().withNetwork(network)).withEnv("WIREMOCK_OPTIONS", "--global-response-templating --verbose");
    }

    public static LocalStackContainer createLocalStackContainer() {
        return (LocalStackContainer)((LocalStackContainer)new LocalStackContainer(DockerImageName.parse((String)LOCALSTACK_IMAGE).withTag(LOCALSTACK_TAG)).withExposedPorts(new Integer[]{4566})).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)"LocalStackContainer")));
    }

    public static LocalStackContainer createLocalStackContainerWithin(Network network) {
        return (LocalStackContainer)((LocalStackContainer)DockerContainers.createLocalStackContainer().withNetwork(network)).withNetworkAliases(new String[]{LOCALSTACK_ALIAS});
    }

    @NotNull
    public static String getAppInfoRegex() {
        String pattern = "ACS HXI Connector\\/%s ACS\\/.*";
        String appVersion = DockerContainers.escapeSpecialChars(DockerTags.getHxiConnectorTag());
        return pattern.formatted(appVersion);
    }

    private static String escapeSpecialChars(String string) {
        return SPECIAL_REGEX_CHARS.matcher(string).replaceAll("\\\\$0");
    }

    @Generated
    private DockerContainers() {
    }
}

