/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.messaging.repository;

import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.RepositoryInformation;
import org.alfresco.hxi_connector.common.config.properties.Application;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInfoProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationInfoProvider.class);
    public static final String APP_INFO_PATTERN = "ACS HXI Connector/%s ACS/%s (%s)";
    public static final String USER_AGENT_DATA = "user-agent-data";
    public static final String USER_AGENT_PARAM = String.format("&userAgent=${exchangeProperty.%s}", "user-agent-data");
    private final RepositoryInformation repositoryInformation;
    private final Application applicationProperties;
    private String applicationInfo;

    public String getUserAgentData() {
        if (StringUtils.isBlank((CharSequence)this.applicationInfo)) {
            log.debug("Calculating user agent data.");
            this.applicationInfo = this.calculateUserAgentData();
        }
        log.debug("User agent data: {}", (Object)this.applicationInfo);
        return this.applicationInfo;
    }

    public String getSourceId() {
        return this.applicationProperties.getSourceId();
    }

    private String calculateUserAgentData() {
        String applicationVersion = this.applicationProperties.getVersion();
        String repositoryVersion = this.repositoryInformation.getRepositoryVersion();
        String osVersion = System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
        return String.format(APP_INFO_PATTERN, applicationVersion, repositoryVersion, osVersion);
    }

    @Generated
    public ApplicationInfoProvider(RepositoryInformation repositoryInformation, Application applicationProperties) {
        this.repositoryInformation = repositoryInformation;
        this.applicationProperties = applicationProperties;
    }
}

