/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api;

import java.util.Collections;
import java.util.List;
import org.alfresco.hxi_connector.hxi_extension.rest.api.QuestionFeedbackRelation;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.FeedbackModel;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.FeedbackType;
import org.alfresco.hxi_connector.hxi_extension.service.HxInsightClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.extensions.webscripts.WebScriptException;

@ExtendWith(value={MockitoExtension.class})
public class QuestionFeedbackRelationshipTest {
    @InjectMocks
    QuestionFeedbackRelation questionFeedbackRelation;
    @Mock
    HxInsightClient mockHxInsightClient;

    @Test
    void testFeedbackCanBeSubmittedSuccessfully() {
        FeedbackModel feedback = new FeedbackModel(FeedbackType.LIKE, "Thanks for the evidence-based solution to my problem!");
        List actual = this.questionFeedbackRelation.create("question-id", List.of(feedback), null);
        Assertions.assertEquals(List.of(feedback), (Object)actual);
    }

    @Test
    void testMultiplePiecesOfFeedbackThrowsException() {
        FeedbackModel feedbackA = new FeedbackModel(FeedbackType.LIKE, null);
        FeedbackModel feedbackB = new FeedbackModel(FeedbackType.DISLIKE, "Churros are not suitable for use in surgery");
        Assertions.assertThrows(WebScriptException.class, () -> this.questionFeedbackRelation.create("question-id", List.of(feedbackA, feedbackB), null));
    }

    @Test
    void testNoFeedbackThrowsException() {
        Assertions.assertThrows(WebScriptException.class, () -> this.questionFeedbackRelation.create("question-id", Collections.emptyList(), null));
    }
}

