/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.service;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.hxi_connector.common.exception.ValidationException;
import org.alfresco.hxi_connector.hxi_extension.rest.api.data_model.PredictionDataModel;
import org.alfresco.hxi_connector.hxi_extension.rest.api.exception.PredictionStateChangedException;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.ReviewStatus;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.UpdateType;
import org.alfresco.hxi_connector.hxi_extension.service.PredictionServiceImpl;
import org.alfresco.hxi_connector.hxi_extension.service.model.Prediction;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class PredictionServiceImplTest {
    private static final NodeRef NODE_REF = new NodeRef("node://ref/");
    private static final NodeRef PREDICTION_NODE_REF = new NodeRef("prediction://node/ref/");
    private static final String NAMESPACE = "http://namespace";
    private static final String NAMESPACE_PREFIX = "ns";
    private static final QName PROPERTY_QNAME = QName.createQName((String)"http://namespace", (String)"propertyName");
    private static final ChildAssociationRef CHILD_ASSOC_REF = new ChildAssociationRef(PredictionDataModel.ASSOC_PREDICTED_BY, NODE_REF, PROPERTY_QNAME, PREDICTION_NODE_REF);
    @InjectMocks
    private PredictionServiceImpl predictionService;
    @Mock
    private NodeService nodeService;
    @Mock
    private NamespaceService namespaceService;

    @Test
    public void testGetPredictedProperties_noPredictions() {
        BDDMockito.given((Object)this.nodeService.getChildAssocs(NODE_REF, Set.of(PredictionDataModel.TYPE_PREDICTION))).willReturn(List.of());
        List predictedProperties = this.predictionService.getPredictedProperties(NODE_REF);
        Assertions.assertEquals(Collections.emptyList(), (Object)predictedProperties);
    }

    @Test
    public void testGetPredictedProperties_withPredictions() {
        BDDMockito.given((Object)this.nodeService.getChildAssocs(NODE_REF, Set.of(PredictionDataModel.TYPE_PREDICTION))).willReturn(List.of(CHILD_ASSOC_REF));
        BDDMockito.given((Object)this.namespaceService.getPrefixes(NAMESPACE)).willReturn(Set.of(NAMESPACE_PREFIX));
        List predictedProperties = this.predictionService.getPredictedProperties(NODE_REF);
        Assertions.assertEquals(List.of("ns:propertyName"), (Object)predictedProperties);
    }

    @Test
    public void testGetPredictions_noPredictions() {
        List predictions = this.predictionService.getPredictions(NODE_REF);
        Assertions.assertEquals(Collections.emptyList(), (Object)predictions);
    }

    @Test
    public void testGetPredictions_withPredictions() {
        Map<QName, String> properties = Map.of(PredictionDataModel.PROP_PREDICTION_DATE_TIME, new Date(1234567890L), PredictionDataModel.PROP_CONFIDENCE_LEVEL, Float.valueOf(0.5f), PredictionDataModel.PROP_MODEL_ID, "hx-model-id", PredictionDataModel.PROP_PREDICTION_VALUE, "blue", PredictionDataModel.PROP_PREVIOUS_VALUE, "red", PredictionDataModel.PROP_UPDATE_TYPE, UpdateType.AUTOCORRECT.toString(), PredictionDataModel.PROP_REVIEW_STATUS, ReviewStatus.UNREVIEWED.toString());
        BDDMockito.given((Object)this.nodeService.getProperties(PREDICTION_NODE_REF)).willReturn(properties);
        BDDMockito.given((Object)this.nodeService.getChildAssocs(NODE_REF, Set.of(PredictionDataModel.TYPE_PREDICTION))).willReturn(List.of(CHILD_ASSOC_REF));
        BDDMockito.given((Object)this.namespaceService.getPrefixes(NAMESPACE)).willReturn(Set.of(NAMESPACE_PREFIX));
        List predictions = this.predictionService.getPredictions(NODE_REF);
        Prediction expectedPrediction = new Prediction(PREDICTION_NODE_REF.getId(), "ns:propertyName", new Date(1234567890L), 0.5f, "hx-model-id", (Serializable)((Object)"blue"), (Serializable)((Object)"red"), UpdateType.AUTOCORRECT, ReviewStatus.UNREVIEWED);
        Assertions.assertEquals(List.of(expectedPrediction), (Object)predictions);
    }

    @Test
    public void testApplyPredictions_newPrediction() {
        BDDMockito.given((Object)this.nodeService.getChildAssocs(NODE_REF, Set.of(PredictionDataModel.TYPE_PREDICTION))).willReturn(List.of());
        BDDMockito.given((Object)this.nodeService.getProperties(NODE_REF)).willReturn(Map.of(PROPERTY_QNAME, "red"));
        BDDMockito.given((Object)this.namespaceService.getNamespaceURI(NAMESPACE_PREFIX)).willReturn((Object)NAMESPACE);
        Map<QName, String> expectedProperties = Map.of(PredictionDataModel.PROP_PREDICTION_DATE_TIME, new Date(1234567890L), PredictionDataModel.PROP_CONFIDENCE_LEVEL, Float.valueOf(0.5f), PredictionDataModel.PROP_MODEL_ID, "hx-model-id", PredictionDataModel.PROP_PREDICTION_VALUE, "blue", PredictionDataModel.PROP_PREVIOUS_VALUE, "red", PredictionDataModel.PROP_UPDATE_TYPE, UpdateType.AUTOCORRECT, PredictionDataModel.PROP_REVIEW_STATUS, ReviewStatus.UNREVIEWED.toString());
        BDDMockito.given((Object)this.nodeService.createNode(NODE_REF, PredictionDataModel.ASSOC_PREDICTED_BY, PROPERTY_QNAME, PredictionDataModel.TYPE_PREDICTION, expectedProperties)).willReturn((Object)CHILD_ASSOC_REF);
        Prediction prediction = new Prediction(null, "ns:propertyName", new Date(1234567890L), 0.5f, "hx-model-id", (Serializable)((Object)"blue"), null, UpdateType.AUTOCORRECT, ReviewStatus.UNREVIEWED);
        List returnedPredictions = this.predictionService.applyPredictions(NODE_REF, List.of(prediction));
        Prediction expectedPrediction = new Prediction(PREDICTION_NODE_REF.getId(), "ns:propertyName", new Date(1234567890L), 0.5f, "hx-model-id", (Serializable)((Object)"blue"), (Serializable)((Object)"red"), UpdateType.AUTOCORRECT, ReviewStatus.UNREVIEWED);
        Assertions.assertEquals(List.of(expectedPrediction), (Object)returnedPredictions);
        this.assertPropertySet(NODE_REF, PROPERTY_QNAME, "blue");
    }

    @Test
    public void testApplyPredictions_updatedPrediction() {
        BDDMockito.given((Object)this.nodeService.getChildAssocs(NODE_REF, Set.of(PredictionDataModel.TYPE_PREDICTION))).willReturn(List.of(CHILD_ASSOC_REF));
        BDDMockito.given((Object)this.nodeService.getProperties(NODE_REF)).willReturn(Map.of(PROPERTY_QNAME, "green"));
        BDDMockito.given((Object)this.nodeService.getProperties(PREDICTION_NODE_REF)).willReturn(Map.of(PredictionDataModel.PROP_PREDICTION_VALUE, "green", PredictionDataModel.PROP_PREVIOUS_VALUE, "red"));
        BDDMockito.given((Object)this.namespaceService.getNamespaceURI(NAMESPACE_PREFIX)).willReturn((Object)NAMESPACE);
        Prediction prediction = new Prediction(null, "ns:propertyName", new Date(1234567890L), 0.5f, "hx-model-id", (Serializable)((Object)"blue"), null, UpdateType.AUTOCORRECT, ReviewStatus.UNREVIEWED);
        List returnedPredictions = this.predictionService.applyPredictions(NODE_REF, List.of(prediction));
        Prediction expectedPrediction = new Prediction(PREDICTION_NODE_REF.getId(), "ns:propertyName", new Date(1234567890L), 0.5f, "hx-model-id", (Serializable)((Object)"blue"), (Serializable)((Object)"red"), UpdateType.AUTOCORRECT, ReviewStatus.UNREVIEWED);
        Assertions.assertEquals(List.of(expectedPrediction), (Object)returnedPredictions);
        this.assertPropertySet(NODE_REF, PROPERTY_QNAME, "blue");
    }

    private void assertPropertySet(NodeRef nodeRef, QName propertyQName, String expectedValue) {
        ArgumentCaptor propertyCaptor = ArgumentCaptor.forClass(Map.class);
        ((NodeService)BDDMockito.then((Object)this.nodeService).should()).setProperties((NodeRef)ArgumentMatchers.eq((Object)nodeRef), (Map)propertyCaptor.capture());
        Assertions.assertEquals((Object)expectedValue, ((Map)propertyCaptor.getValue()).get(propertyQName));
    }

    private void assertSinglePropertySet(NodeRef nodeRef, QName propertyQName, Serializable expectedValue) {
        ArgumentCaptor propertyCaptor = ArgumentCaptor.forClass(Serializable.class);
        ((NodeService)BDDMockito.then((Object)this.nodeService).should()).setProperty((NodeRef)ArgumentMatchers.eq((Object)nodeRef), (QName)ArgumentMatchers.eq((Object)propertyQName), (Serializable)propertyCaptor.capture());
        Assertions.assertEquals((Object)expectedValue, (Object)propertyCaptor.getValue());
    }

    @Test
    public void testApplyPredictions_updateAfterRejectedPrediction() {
        BDDMockito.given((Object)this.nodeService.getChildAssocs(NODE_REF, Set.of(PredictionDataModel.TYPE_PREDICTION))).willReturn(List.of(CHILD_ASSOC_REF));
        BDDMockito.given((Object)this.nodeService.getProperties(NODE_REF)).willReturn(Map.of(PROPERTY_QNAME, "red"));
        BDDMockito.given((Object)this.nodeService.getProperties(PREDICTION_NODE_REF)).willReturn(Map.of(PredictionDataModel.PROP_PREDICTION_VALUE, "green", PredictionDataModel.PROP_PREVIOUS_VALUE, "red"));
        BDDMockito.given((Object)this.namespaceService.getNamespaceURI(NAMESPACE_PREFIX)).willReturn((Object)NAMESPACE);
        Prediction prediction = new Prediction(null, "ns:propertyName", new Date(1234567890L), 0.5f, "hx-model-id", (Serializable)((Object)"blue"), null, UpdateType.AUTOCORRECT, ReviewStatus.UNREVIEWED);
        List returnedPredictions = this.predictionService.applyPredictions(NODE_REF, List.of(prediction));
        Assertions.assertEquals(Collections.emptyList(), (Object)returnedPredictions);
        BDDMockito.then((Object)this.nodeService).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testApplyPredictions_missingPrediction() {
        Assertions.assertThrows(ValidationException.class, () -> this.predictionService.applyPredictions(NODE_REF, Collections.emptyList()));
    }

    @Test
    public void testReviewPrediction_propertyValueChangedBeforePredictionReview() {
        this.reviewPredictionTestSetup(ReviewStatus.UNREVIEWED);
        BDDMockito.given((Object)this.nodeService.getProperty(NODE_REF, PROPERTY_QNAME)).willReturn((Object)"yellow");
        Assertions.assertThrows(PredictionStateChangedException.class, () -> this.predictionService.reviewPrediction(PREDICTION_NODE_REF, ReviewStatus.CONFIRMED));
    }

    @Test
    public void testReviewPrediction_predictionAlreadyReviewedAndReviewStatusChangeRequested() {
        this.reviewPredictionTestSetup(ReviewStatus.REJECTED);
        BDDMockito.given((Object)this.nodeService.getProperty(NODE_REF, PROPERTY_QNAME)).willReturn((Object)"blue");
        BDDMockito.given((Object)this.nodeService.getProperty(PREDICTION_NODE_REF, PredictionDataModel.PROP_REVIEW_STATUS)).willReturn((Object)ReviewStatus.REJECTED.toString());
        Assertions.assertThrows(PredictionStateChangedException.class, () -> this.predictionService.reviewPrediction(PREDICTION_NODE_REF, ReviewStatus.CONFIRMED));
    }

    @Test
    public void testReviewPrediction_predictionConfirmed() {
        this.reviewPredictionTestSetup(ReviewStatus.UNREVIEWED);
        BDDMockito.given((Object)this.nodeService.getProperty(NODE_REF, PROPERTY_QNAME)).willReturn((Object)"blue");
        BDDMockito.given((Object)this.nodeService.getProperty(PREDICTION_NODE_REF, PredictionDataModel.PROP_REVIEW_STATUS)).willReturn((Object)ReviewStatus.UNREVIEWED.toString());
        this.predictionService.reviewPrediction(PREDICTION_NODE_REF, ReviewStatus.CONFIRMED);
        this.assertSinglePropertySet(PREDICTION_NODE_REF, PredictionDataModel.PROP_REVIEW_STATUS, (Serializable)((Object)ReviewStatus.CONFIRMED.toString()));
    }

    @Test
    public void testReviewPrediction_predictionRejected() {
        this.reviewPredictionTestSetup(ReviewStatus.UNREVIEWED);
        BDDMockito.given((Object)this.nodeService.getProperty(NODE_REF, PROPERTY_QNAME)).willReturn((Object)"blue");
        BDDMockito.given((Object)this.nodeService.getProperty(PREDICTION_NODE_REF, PredictionDataModel.PROP_REVIEW_STATUS)).willReturn((Object)ReviewStatus.UNREVIEWED.toString());
        this.predictionService.reviewPrediction(PREDICTION_NODE_REF, ReviewStatus.REJECTED);
        this.assertSinglePropertySet(PREDICTION_NODE_REF, PredictionDataModel.PROP_REVIEW_STATUS, (Serializable)((Object)ReviewStatus.REJECTED.toString()));
        this.assertSinglePropertySet(NODE_REF, PROPERTY_QNAME, (Serializable)((Object)"red"));
    }

    private void reviewPredictionTestSetup(ReviewStatus initialReviewStatus) {
        Map<QName, String> properties = Map.of(PredictionDataModel.PROP_PREDICTION_DATE_TIME, new Date(1234567890L), PredictionDataModel.PROP_CONFIDENCE_LEVEL, Float.valueOf(0.5f), PredictionDataModel.PROP_MODEL_ID, "hx-model-id", PredictionDataModel.PROP_PREDICTION_VALUE, "blue", PredictionDataModel.PROP_PREVIOUS_VALUE, "red", PredictionDataModel.PROP_UPDATE_TYPE, UpdateType.AUTOCORRECT.toString(), PredictionDataModel.PROP_REVIEW_STATUS, initialReviewStatus.toString());
        BDDMockito.given((Object)this.nodeService.getProperties(PREDICTION_NODE_REF)).willReturn(properties);
        BDDMockito.given((Object)this.namespaceService.getNamespaceURI(NAMESPACE_PREFIX)).willReturn((Object)NAMESPACE);
        BDDMockito.given((Object)this.namespaceService.getPrefixes(NAMESPACE)).willReturn(Set.of(NAMESPACE_PREFIX));
        BDDMockito.given((Object)this.nodeService.getPrimaryParent(PREDICTION_NODE_REF)).willReturn((Object)CHILD_ASSOC_REF);
    }
}

