/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.messaging.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.RepositoryInformation;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.api.DiscoveryApiResponse;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.common.util.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryApiRepositoryInformation
implements RepositoryInformation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiscoveryApiRepositoryInformation.class);
    private final String discoveryEndpoint;
    private final AuthService authService;
    private final ObjectMapper objectMapper;
    private final HttpClient client;

    @Override
    public String getRepositoryVersion() {
        EnsureUtils.ensureNotBlank(this.discoveryEndpoint, "ACS Discovery API endpoint must not be blank", new Object[0]);
        log.debug("Sending ACS Discovery API request to: {}", (Object)this.discoveryEndpoint);
        try {
            return this.getDiscoverApiResponse().getFullVersion();
        }
        catch (IOException | InterruptedException e) {
            Set<Class<? extends Throwable>> retryReasons = Set.of(IOException.class, InterruptedException.class);
            throw ErrorUtils.wrapErrorIfNecessary(e, retryReasons);
        }
    }

    private DiscoveryApiResponse getDiscoverApiResponse() throws IOException, InterruptedException {
        Map.Entry<String, String> authHeader = this.authService.getAuthHeader("alfresco");
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.discoveryEndpoint)).header(authHeader.getKey(), authHeader.getValue()).GET().build();
        HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
        ErrorUtils.throwExceptionOnUnexpectedStatusCode(response.statusCode(), 200);
        DiscoveryApiResponse discoveryApiResponse = (DiscoveryApiResponse)this.objectMapper.readValue(response.body(), DiscoveryApiResponse.class);
        log.trace("Discovery API response: {}", (Object)discoveryApiResponse);
        return discoveryApiResponse;
    }

    @Generated
    public DiscoveryApiRepositoryInformation(String discoveryEndpoint, AuthService authService, ObjectMapper objectMapper, HttpClient client) {
        this.discoveryEndpoint = discoveryEndpoint;
        this.authService = authService;
        this.objectMapper = objectMapper;
        this.client = client;
    }
}

