/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api;

import java.util.List;
import java.util.Set;
import org.alfresco.hxi_connector.hxi_extension.rest.api.AgentsQuestionsRelation;
import org.alfresco.hxi_connector.hxi_extension.rest.api.config.QuestionsApiConfig;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.QuestionModel;
import org.alfresco.hxi_connector.hxi_extension.service.QuestionPermissionService;
import org.alfresco.hxi_connector.hxi_extension.service.QuestionService;
import org.alfresco.hxi_connector.hxi_extension.service.model.Question;
import org.alfresco.hxi_connector.hxi_extension.service.model.RestrictionQuery;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.extensions.webscripts.WebScriptException;

public class AgentsQuestionsRelationTest {
    private static final String AGENT_ID = "agent-id";
    private final QuestionService questionService = (QuestionService)Mockito.mock(QuestionService.class);
    private final QuestionsApiConfig questionConfig = new QuestionsApiConfig(3);
    private final QuestionPermissionService questionPermissionService = (QuestionPermissionService)Mockito.mock(QuestionPermissionService.class);
    private final AgentsQuestionsRelation agentsQuestionsRelation = new AgentsQuestionsRelation(this.questionService, this.questionConfig, this.questionPermissionService);

    @BeforeEach
    public void setUp() {
        BDDMockito.given((Object)this.questionPermissionService.hasPermissionToAskAboutDocuments((Question)ArgumentMatchers.any())).willReturn((Object)true);
    }

    @Test
    public void shouldFailIfAskedMultipleQuestions() {
        List<QuestionModel> questions = List.of((QuestionModel)Mockito.mock(QuestionModel.class), (QuestionModel)Mockito.mock(QuestionModel.class));
        WebScriptException webScriptException = (WebScriptException)Assertions.assertThrows(WebScriptException.class, () -> this.agentsQuestionsRelation.create(AGENT_ID, questions, null));
        Assertions.assertTrue((boolean)webScriptException.getMessage().contains("You can only ask one question at a time."));
        Assertions.assertEquals((int)400, (int)webScriptException.getStatus());
    }

    @Test
    public void shouldFailIfAskedAboutTooManyDocuments() {
        QuestionModel question = new QuestionModel(null, "What is the capital of France?", new RestrictionQuery(Set.of("node-id-1", "node-id-2", "node-id-3", "node-id-4")));
        WebScriptException webScriptException = (WebScriptException)Assertions.assertThrows(WebScriptException.class, () -> this.agentsQuestionsRelation.create(AGENT_ID, List.of(question), null));
        Assertions.assertTrue((boolean)webScriptException.getMessage().contains("You can only ask about up to 3 nodes at a time"));
        Assertions.assertEquals((int)400, (int)webScriptException.getStatus());
    }

    @Test
    public void shouldFailIfHasNoPermissionsToViewDocuments() {
        QuestionModel question = new QuestionModel(null, "What is the capital of France?", new RestrictionQuery(Set.of("node-id-1")));
        BDDMockito.given((Object)this.questionPermissionService.hasPermissionToAskAboutDocuments((Question)ArgumentMatchers.any())).willReturn((Object)false);
        WebScriptException webScriptException = (WebScriptException)Assertions.assertThrows(WebScriptException.class, () -> this.agentsQuestionsRelation.create(AGENT_ID, List.of(question), null));
        Assertions.assertTrue((boolean)webScriptException.getMessage().contains("You don't have permission to ask about some nodes"));
        Assertions.assertEquals((int)403, (int)webScriptException.getStatus());
    }

    @Test
    public void shouldReturnQuestionWithId() {
        QuestionModel question = new QuestionModel(null, "What is the capital of France?", new RestrictionQuery(Set.of("node-id")));
        String questionId = "a13c4b3d-4b3d-4b3d-4b3d-4b3d4b3d4b3d";
        BDDMockito.given((Object)this.questionService.askQuestion((String)ArgumentMatchers.eq((Object)AGENT_ID), (Question)ArgumentMatchers.any())).willReturn((Object)questionId);
        List questionIds = this.agentsQuestionsRelation.create(AGENT_ID, List.of(question), null);
        Assertions.assertEquals((int)1, (int)questionIds.size());
        Assertions.assertEquals((Object)questionId, (Object)((QuestionModel)questionIds.get(0)).getQuestionId());
    }
}

