/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.config.properties;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Positive;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;

public record Repository(@NotBlank String eventsEndpoint, String discoveryEndpoint, String versionOverride, HealthProbe healthProbe) {
    public Repository(@NotBlank String eventsEndpoint, String discoveryEndpoint, String versionOverride, HealthProbe healthProbe) {
        if (StringUtils.isBlank((CharSequence)discoveryEndpoint) && StringUtils.isBlank((CharSequence)versionOverride)) {
            throw new IllegalStateException("Either property %s or %s must be set in the Live Ingester configuration.".formatted("alfresco.repository.discovery-endpoint", "alfresco.repository.version-override"));
        }
        if (StringUtils.isNotBlank((CharSequence)discoveryEndpoint) && StringUtils.isBlank((CharSequence)versionOverride) && StringUtils.isBlank((CharSequence)healthProbe.endpoint())) {
            throw new IllegalStateException("Property %s must be set in the Live Ingester configuration when property %s is set and % property is blank.".formatted("alfresco.repository.health-probe.endpoint", "alfresco.repository.discovery-endpoint", "alfresco.repository.version-override"));
        }
    }

    @Validated
    public record HealthProbe(String endpoint, @Positive int timeoutSeconds, @Positive int intervalSeconds) {
    }
}

