/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight.storage.connector;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.ApplicationInfoProvider;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.alfresco.hxi_connector.common.util.ErrorUtils;
import org.alfresco.hxi_connector.live_ingester.adapters.config.IntegrationProperties;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight.storage.connector.StorageLocationRequester;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight.storage.connector.model.PreSignedUrlResponse;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.util.LoggingUtils;
import org.alfresco.hxi_connector.live_ingester.domain.exception.LiveIngesterRuntimeException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class PreSignedUrlRequester
extends RouteBuilder
implements StorageLocationRequester {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PreSignedUrlRequester.class);
    private static final String LOCAL_ENDPOINT = "direct:" + PreSignedUrlRequester.class.getSimpleName();
    static final String ROUTE_ID = "presigned-url-requester";
    static final String STORAGE_LOCATION_PROPERTY = "url";
    static final String CONTENT_ID_PROPERTY = "id";
    private static final int EXPECTED_STATUS_CODE = 200;
    private final CamelContext camelContext;
    private final IntegrationProperties integrationProperties;
    private final AuthService authService;
    private final ApplicationInfoProvider applicationInfoProvider;

    public void configure() {
        String storageRequestEndpoint = this.integrationProperties.hylandExperience().storage().location().endpoint() + ApplicationInfoProvider.USER_AGENT_PARAM;
        ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Exception.class).log(LoggingLevel.ERROR, log, "Storage :: Unexpected response while requesting pre-signed URL - Endpoint: %s".formatted(storageRequestEndpoint))).process(exchange -> LoggingUtils.logMaskedExchangeState(exchange, log, Level.ERROR))).process(this::wrapErrorIfNecessary)).stop();
        ((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(LOCAL_ENDPOINT).id(ROUTE_ID)).setProperty("user-agent-data", () -> ((ApplicationInfoProvider)this.applicationInfoProvider).getUserAgentData())).process(arg_0 -> ((AuthService)this.authService).setHxIAuthorizationHeaders(arg_0))).toD(storageRequestEndpoint)).choice().when(this.header("CamelHttpResponseCode").isEqualTo((Object)String.valueOf(200))).unmarshal().json(JsonLibrary.Jackson, List.class).process(this::extractResponse)).otherwise().process(this::throwExceptionOnUnexpectedStatusCode)).endChoice().end();
    }

    @Override
    @Retryable(retryFor={EndpointServerErrorException.class}, maxAttemptsExpression="#{@integrationProperties.hylandExperience.storage.location.retry.attempts}", backoff=@Backoff(delayExpression="#{@integrationProperties.hylandExperience.storage.location.retry.initialDelay}", multiplierExpression="#{@integrationProperties.hylandExperience.storage.location.retry.delayMultiplier}"))
    public PreSignedUrlResponse requestStorageLocation() {
        return (PreSignedUrlResponse)this.camelContext.createFluentProducerTemplate().to(LOCAL_ENDPOINT).request(PreSignedUrlResponse.class);
    }

    private void extractResponse(Exchange exchange) {
        exchange.getMessage().setBody((Object)this.extractStorageResponse((List)exchange.getIn().getBody(List.class)), PreSignedUrlResponse.class);
    }

    private PreSignedUrlResponse extractStorageResponse(List<Map<String, Object>> response) {
        URL url;
        if (response.isEmpty()) {
            throw new EndpointServerErrorException("Storage :: Unable to extract list of pre-signed URL responses");
        }
        Map<String, Object> map = response.get(0);
        if (!map.containsKey(STORAGE_LOCATION_PROPERTY)) {
            throw new EndpointServerErrorException("Storage :: Missing url property in response!");
        }
        try {
            url = new URL(String.valueOf(map.get(STORAGE_LOCATION_PROPERTY)));
        }
        catch (MalformedURLException e) {
            throw new EndpointServerErrorException("Storage :: Parsing URL from response property failed!", (Throwable)e);
        }
        if (!map.containsKey(CONTENT_ID_PROPERTY)) {
            throw new EndpointServerErrorException("Storage :: Missing id property in response!");
        }
        String contentId = (String)map.get(CONTENT_ID_PROPERTY);
        return new PreSignedUrlResponse(url, contentId);
    }

    private void throwExceptionOnUnexpectedStatusCode(Exchange exchange) {
        int actualStatusCode = (Integer)exchange.getMessage().getHeader("CamelHttpResponseCode", Integer.class);
        if (actualStatusCode != 200) {
            log.warn("Unexpected response status code - expecting: %d, received: %d".formatted(200, actualStatusCode));
        }
        ErrorUtils.throwExceptionOnUnexpectedStatusCode((int)actualStatusCode, (int)200);
    }

    private void wrapErrorIfNecessary(Exchange exchange) {
        Exception cause = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
        Set retryReasons = this.integrationProperties.hylandExperience().storage().upload().retry().reasons();
        ErrorUtils.wrapErrorAndThrowIfNecessary((Exception)cause, (Set)retryReasons, LiveIngesterRuntimeException.class);
    }

    @Generated
    public PreSignedUrlRequester(CamelContext camelContext, IntegrationProperties integrationProperties, AuthService authService, ApplicationInfoProvider applicationInfoProvider) {
        this.camelContext = camelContext;
        this.integrationProperties = integrationProperties;
        this.authService = authService;
        this.applicationInfoProvider = applicationInfoProvider;
    }
}

