/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.transform.request;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.alfresco.hxi_connector.live_ingester.adapters.config.IntegrationProperties;
import org.alfresco.hxi_connector.live_ingester.adapters.config.properties.Transform;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.transform.model.ClientData;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.transform.request.model.ATSTransformRequest;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.util.LoggingUtils;
import org.alfresco.hxi_connector.live_ingester.domain.ports.transform_engine.TransformRequest;
import org.alfresco.hxi_connector.live_ingester.domain.ports.transform_engine.TransformRequester;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.stereotype.Component;

@Component
public class ATSTransformRequester
extends RouteBuilder
implements TransformRequester {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ATSTransformRequester.class);
    private static final String LOCAL_ENDPOINT = "direct:" + ATSTransformRequester.class.getSimpleName();
    private static final String ROUTE_ID = "transform-request-publisher";
    protected static final String TIMEOUT_KEY = "timeout";
    private final CamelContext camelContext;
    private final IntegrationProperties integrationProperties;

    public void configure() {
        String transformEndpoint = this.integrationProperties.alfresco().transform().request().endpoint();
        ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Exception.class).log(LoggingLevel.ERROR, log, "Transform :: Unexpected response while requesting for transformation - Endpoint: %s".formatted(transformEndpoint))).process(exchange -> LoggingUtils.logMaskedExchangeState(exchange, log, Level.ERROR))).stop();
        ((RouteDefinition)this.from(LOCAL_ENDPOINT).routeId(ROUTE_ID).marshal().json().log(LoggingLevel.DEBUG, log, "Transform :: Sending transform request: ${body}")).to(transformEndpoint);
    }

    @Override
    public void requestTransform(TransformRequest transformRequest) {
        ATSTransformRequest atsTransformRequest = this.toTransformRequest(transformRequest, 0);
        this.camelContext.createProducerTemplate().sendBody(LOCAL_ENDPOINT, (Object)atsTransformRequest);
        log.info("Transform :: Successfully sent transform request for node: {} and target type: {}", (Object)transformRequest.nodeRef(), (Object)transformRequest.targetMimeType());
    }

    public void requestTransformRetry(TransformRequest transformRequest, int attempt) {
        ATSTransformRequest atsTransformRequest = this.toTransformRequest(transformRequest, attempt);
        log.info("Transform :: Redelivering transform request: {} attempt: {}", (Object)atsTransformRequest, (Object)attempt);
        this.camelContext.createProducerTemplate().sendBody(LOCAL_ENDPOINT, (Object)atsTransformRequest);
    }

    protected ATSTransformRequest toTransformRequest(TransformRequest transformRequest, int attempt) {
        Transform transformProperties = this.integrationProperties.alfresco().transform();
        String targetMimeType = transformRequest.targetMimeType();
        HashMap<String, String> transformOptions = new HashMap<String, String>();
        transformOptions.put(TIMEOUT_KEY, String.valueOf(transformProperties.request().timeout()));
        Map<String, Map<String, String>> configuredOptions = transformProperties.request().options();
        if (configuredOptions != null && configuredOptions.containsKey(targetMimeType)) {
            transformOptions.putAll(configuredOptions.get(targetMimeType));
        }
        return new ATSTransformRequest(transformRequest.nodeRef(), targetMimeType, new ClientData(transformRequest.nodeRef(), targetMimeType, attempt, transformRequest.timestamp()), transformOptions, transformProperties.response().queueName());
    }

    @Generated
    public ATSTransformRequester(CamelContext camelContext, IntegrationProperties integrationProperties) {
        this.camelContext = camelContext;
        this.integrationProperties = integrationProperties;
    }
}

