/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.filter;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.alfresco.hxi_connector.live_ingester.adapters.config.properties.Filter;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.filter.RepoEventFilterApplier;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.mapper.CamelEventMapper;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.util.EventUtils;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RepoEventFilterHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RepoEventFilterHandler.class);
    private final List<RepoEventFilterApplier> repoEventFilterAppliers;
    private final CamelEventMapper camelEventMapper;

    public boolean handleAndGetAllowed(Exchange exchange, Filter filter) {
        FilteringResults filteringResults = this.calculateFilteringResults(exchange, filter);
        filteringResults.eventTypeOverride.ifPresent(type -> exchange.getIn().setBody(this.camelEventMapper.alterRepoEvent(exchange, (String)type)));
        return filteringResults.allowed;
    }

    private FilteringResults calculateFilteringResults(Exchange exchange, Filter filter) {
        RepoEvent repoEvent = (RepoEvent)exchange.getIn().getBody(RepoEvent.class);
        boolean allowCurrentNode = true;
        boolean allowPreviousNode = true;
        boolean eventTypeUpdated = EventUtils.isEventTypeUpdated((RepoEvent<DataAttributes<NodeResource>>)repoEvent);
        for (RepoEventFilterApplier filterApplier : this.repoEventFilterAppliers) {
            log.atDebug().log("Filtering :: Applying filters {} to current repo event of id: {}", (Object)filter, (Object)repoEvent.getId());
            boolean allow = filterApplier.isNodeAllowed((NodeResource)repoEvent.getData().getResource(), filter);
            boolean bl = allowCurrentNode = allowCurrentNode && allow;
            if (!eventTypeUpdated || !allowPreviousNode) continue;
            log.atDebug().log("Filtering :: Applying filters {} to previous version of repo event of id: {}", (Object)filter, (Object)repoEvent.getId());
            allowPreviousNode = filterApplier.isNodeBeforeAllowed(allow, (NodeResource)repoEvent.getData().getResourceBefore(), filter);
        }
        Optional<String> eventTypeOverride = eventTypeUpdated ? this.resolveEventType(allowPreviousNode, allowCurrentNode) : Optional.empty();
        boolean overallResult = allowCurrentNode || allowPreviousNode && eventTypeUpdated;
        log.atDebug().log("Filtering :: Overall filtering results. Allow: {}, allow current: {}, allow previous: {}", new Object[]{overallResult, allowCurrentNode, allowPreviousNode});
        return new FilteringResults(overallResult, eventTypeOverride);
    }

    private Optional<String> resolveEventType(boolean resultBefore, boolean result) {
        if (resultBefore && !result) {
            return Optional.of(EventType.NODE_DELETED.getType());
        }
        if (!resultBefore && result) {
            return Optional.of(EventType.NODE_CREATED.getType());
        }
        return Optional.empty();
    }

    @Generated
    public RepoEventFilterHandler(List<RepoEventFilterApplier> repoEventFilterAppliers, CamelEventMapper camelEventMapper) {
        this.repoEventFilterAppliers = repoEventFilterAppliers;
        this.camelEventMapper = camelEventMapper;
    }

    record FilteringResults(Boolean allowed, Optional<String> eventTypeOverride) {
    }
}

