/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight;

import java.util.Set;
import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.ApplicationInfoProvider;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.alfresco.hxi_connector.common.util.ErrorUtils;
import org.alfresco.hxi_connector.live_ingester.adapters.config.IntegrationProperties;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.util.LoggingUtils;
import org.alfresco.hxi_connector.live_ingester.domain.exception.LiveIngesterRuntimeException;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.IngestionEngineEventPublisher;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.NodeEvent;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;

@Component
public class HxInsightEventPublisher
extends RouteBuilder
implements IngestionEngineEventPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HxInsightEventPublisher.class);
    private static final String LOCAL_ENDPOINT = "direct:" + HxInsightEventPublisher.class.getSimpleName();
    private static final String ROUTE_ID = "insight-event-publisher";
    private static final int EXPECTED_STATUS_CODE = 202;
    private final CamelContext camelContext;
    private final IntegrationProperties integrationProperties;
    private final AuthService authService;
    private final ApplicationInfoProvider applicationInfoProvider;

    public void configure() {
        String ingestionEndpoint = this.integrationProperties.hylandExperience().ingester().endpoint() + ApplicationInfoProvider.USER_AGENT_PARAM;
        ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Exception.class).log(LoggingLevel.ERROR, log, "Ingestion :: Unexpected response - Endpoint: %s".formatted(ingestionEndpoint))).process(exchange -> LoggingUtils.logMaskedExchangeState((Exchange)exchange, (Logger)log, (Level)Level.ERROR))).process(arg_0 -> this.wrapErrorIfNecessary(arg_0))).stop();
        ((ChoiceDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(LOCAL_ENDPOINT).id(ROUTE_ID)).log(LoggingLevel.INFO, log, "Ingestion :: Sending event of type: ${body.eventType} for node with ID: ${body.objectId}")).marshal().json().setProperty("user-agent-data", () -> ((ApplicationInfoProvider)this.applicationInfoProvider).getUserAgentData())).log(LoggingLevel.DEBUG, log, "Ingestion :: Sending event: ${body}. Headers: ${headers}. Endpoint: " + ingestionEndpoint)).process(arg_0 -> ((AuthService)this.authService).setHxIAuthorizationHeaders(arg_0))).toD(ingestionEndpoint)).choice().when(this.header("CamelHttpResponseCode").isNotEqualTo((Object)String.valueOf(202))).process(arg_0 -> this.throwExceptionOnUnexpectedStatusCode(arg_0))).endChoice().end();
    }

    @Retryable(retryFor={EndpointServerErrorException.class}, maxAttemptsExpression="#{@integrationProperties.hylandExperience.ingester.retry.attempts}", backoff=@Backoff(delayExpression="#{@integrationProperties.hylandExperience.ingester.retry.initialDelay}", multiplierExpression="#{@integrationProperties.hylandExperience.ingester.retry.delayMultiplier}"))
    public void publishMessage(NodeEvent event) {
        this.camelContext.createFluentProducerTemplate().to(LOCAL_ENDPOINT).withBody((Object)event).request();
    }

    private void throwExceptionOnUnexpectedStatusCode(Exchange exchange) {
        int actualStatusCode = (Integer)exchange.getMessage().getHeader("CamelHttpResponseCode", Integer.class);
        if (actualStatusCode != 202) {
            log.warn("Unexpected response status code - expecting: %d, received: %d".formatted(202, actualStatusCode));
        }
        ErrorUtils.throwExceptionOnUnexpectedStatusCode((int)actualStatusCode, (int)202);
    }

    private void wrapErrorIfNecessary(Exchange exchange) {
        Exception cause = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
        Set retryReasons = this.integrationProperties.hylandExperience().ingester().retry().reasons();
        ErrorUtils.wrapErrorAndThrowIfNecessary((Exception)cause, (Set)retryReasons, LiveIngesterRuntimeException.class);
    }

    @Generated
    public HxInsightEventPublisher(CamelContext camelContext, IntegrationProperties integrationProperties, AuthService authService, ApplicationInfoProvider applicationInfoProvider) {
        this.camelContext = camelContext;
        this.integrationProperties = integrationProperties;
        this.authService = authService;
        this.applicationInfoProvider = applicationInfoProvider;
    }
}

