/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight.storage;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import lombok.Generated;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight.storage.connector.FileUploadRequest;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight.storage.connector.FileUploader;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight.storage.connector.StorageLocationRequester;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight.storage.connector.model.PreSignedUrlResponse;
import org.alfresco.hxi_connector.live_ingester.domain.exception.LiveIngesterRuntimeException;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.storage.IngestionEngineStorageClient;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.storage.model.IngestContentResponse;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.model.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HttpHxInsightStorageClient
implements IngestionEngineStorageClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpHxInsightStorageClient.class);
    private final StorageLocationRequester storageLocationRequester;
    private final FileUploader fileUploader;

    public IngestContentResponse upload(File file, String contentType, String nodeId) {
        PreSignedUrlResponse preSignedUrlResponse = this.storageLocationRequester.requestStorageLocation();
        log.atDebug().log("Storage :: Received target location with transfer ID: {} for node: {}", (Object)preSignedUrlResponse.id(), (Object)nodeId);
        URL preSignedUrl = preSignedUrlResponse.url();
        try (InputStream fileData = file.data();){
            log.atDebug().log("Storage :: Uploading content rendition of node: {} with size of {} bytes to: {}", new Object[]{nodeId, fileData.available(), preSignedUrl.getPath()});
            this.fileUploader.upload(new FileUploadRequest(new File(fileData), contentType, preSignedUrl), nodeId);
        }
        catch (IOException e) {
            throw new LiveIngesterRuntimeException((Throwable)e);
        }
        return new IngestContentResponse(preSignedUrlResponse.id(), contentType);
    }

    @Generated
    public HttpHxInsightStorageClient(StorageLocationRequester storageLocationRequester, FileUploader fileUploader) {
        this.storageLocationRequester = storageLocationRequester;
        this.fileUploader = fileUploader;
    }
}

