/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.config.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.hxi_connector.live_ingester.adapters.config.jackson.exception.JsonSerializationException;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight.model.FieldType;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.hx_insight.model.FileMetadata;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.ContentProperty;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.UpdateNodeEvent;
import org.springframework.stereotype.Component;

@Component
public class UpdateNodeEventSerializer
extends StdSerializer<UpdateNodeEvent> {
    private static final String NAME = "cm:name";
    private static final String CREATED_AT = "createdAt";
    private static final String MODIFIED_AT = "modifiedAt";
    private static final String ASPECTS_NAMES = "aspectsNames";
    private static final String TYPE = "type";
    private static final String CREATED_BY = "createdBy";
    private static final String MODIFIED_BY = "modifiedBy";
    private static final String ANCESTORS = "ancestors";

    public UpdateNodeEventSerializer() {
        this(null);
    }

    public UpdateNodeEventSerializer(Class<UpdateNodeEvent> t) {
        super(t);
    }

    public void serialize(UpdateNodeEvent event, JsonGenerator jgen, SerializerProvider provider) {
        try {
            jgen.writeStartArray();
            jgen.writeStartObject();
            jgen.writeStringField("objectId", event.getObjectId());
            jgen.writeStringField("sourceId", event.getSourceId());
            jgen.writeStringField("eventType", event.getEventType().getValue());
            jgen.writeNumberField("sourceTimestamp", event.getTimestamp());
            if (!event.getMetadataPropertiesToSet().isEmpty() || !event.getContentPropertiesToSet().isEmpty()) {
                jgen.writeObjectFieldStart("properties");
                event.getMetadataPropertiesToSet().values().forEach(property -> this.writeProperty(jgen, FieldType.VALUE, property.name(), property.value(), true));
                event.getContentPropertiesToSet().values().forEach(property -> this.writeProperty(jgen, FieldType.FILE, property.propertyName(), new FileMetadata((ContentProperty)property), true));
                jgen.writeEndObject();
            }
            jgen.writeEndObject();
            jgen.writeEndArray();
        }
        catch (Exception e) {
            throw new JsonSerializationException("Property serialization failed", e);
        }
    }

    void writeProperty(JsonGenerator jgen, FieldType fieldType, String name, Object value, boolean shouldCheckForAnnotation) {
        try {
            Collection collection;
            if (value instanceof Collection && (collection = (Collection)value).isEmpty()) {
                return;
            }
            jgen.writeObjectFieldStart(name);
            if (value instanceof Map) {
                Map nestedMap = (Map)value;
                this.writeNestedMap(jgen, fieldType, nestedMap);
            } else {
                jgen.writeObjectField(this.getLowerCase((Object)fieldType), value);
            }
            boolean hasAnnotation = false;
            if (shouldCheckForAnnotation) {
                hasAnnotation = this.writeAnnotation(jgen, name);
            }
            if (!hasAnnotation) {
                this.writeType(jgen, value);
            }
            jgen.writeEndObject();
        }
        catch (IOException e) {
            throw new JsonSerializationException("UpdateNodeEvent serialization failed", e);
        }
    }

    private boolean writeAnnotation(JsonGenerator jgen, String name) throws IOException {
        boolean hasAnnotation = true;
        switch (name) {
            case "createdAt": {
                jgen.writeObjectField("annotation", (Object)"dateCreated");
                break;
            }
            case "modifiedAt": {
                jgen.writeObjectField("annotation", (Object)"dateModified");
                break;
            }
            case "aspectsNames": {
                jgen.writeObjectField("annotation", (Object)"aspects");
                break;
            }
            case "cm:name": {
                jgen.writeObjectField("annotation", (Object)"name");
                break;
            }
            case "type": {
                jgen.writeObjectField("annotation", (Object)TYPE);
                break;
            }
            case "createdBy": {
                jgen.writeObjectField("annotation", (Object)CREATED_BY);
                break;
            }
            case "modifiedBy": {
                jgen.writeObjectField("annotation", (Object)MODIFIED_BY);
                break;
            }
            case "ancestors": {
                jgen.writeObjectField("annotation", (Object)"hierarchy");
                break;
            }
            default: {
                hasAnnotation = false;
            }
        }
        return hasAnnotation;
    }

    private void writeType(JsonGenerator jgen, Object value) throws IOException {
        if (value instanceof FileMetadata) {
            return;
        }
        String type = this.determineType(value);
        jgen.writeObjectField(TYPE, (Object)type);
    }

    private String getLowerCase(Object object) {
        return object.toString().toLowerCase(Locale.ENGLISH);
    }

    protected String determineType(Object value) {
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof Integer) {
            return "integer";
        }
        if (value instanceof Float || value instanceof Double) {
            return "float";
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("Empty collections should not be passed to selectTypeByValue.");
            }
            Set types = collection.stream().map(this::determineType).collect(Collectors.toSet());
            if (types.size() == 1) {
                return (String)types.iterator().next();
            }
            return "string";
        }
        if (value instanceof Map) {
            return "object";
        }
        return "string";
    }

    private void writeNestedMap(JsonGenerator jgen, FieldType fieldType, Map<?, ?> map) throws IOException {
        jgen.writeObjectFieldStart(this.getLowerCase((Object)fieldType));
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            jgen.writeObjectField(key, value);
        }
        jgen.writeEndObject();
    }
}

