/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.nucleus_sync.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.alfresco.hxi_connector.nucleus_sync.client.ClientException;
import org.alfresco.hxi_connector.nucleus_sync.dto.AlfrescoGroup;
import org.alfresco.hxi_connector.nucleus_sync.dto.AlfrescoPagedResponse;
import org.alfresco.hxi_connector.nucleus_sync.dto.AlfrescoUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class AlfrescoClient {
    private final WebClient webClient;
    private final ObjectMapper objectMapper;
    private final AuthService authService;
    private final String alfrescoBaseUrl;
    private final int timeoutInMins;
    private final int pageSize;
    private static final Logger LOGGER = LoggerFactory.getLogger(AlfrescoClient.class);

    @Autowired
    public AlfrescoClient(AuthService authService, @Value(value="${alfresco.base-url}") String alfrescoBaseUrl, @Value(value="${http-client.timeout-minutes:5}") int timeoutInMins, @Value(value="${alfresco.page-size:100}") int pageSize) {
        this(WebClient.builder().build(), new ObjectMapper(), authService, timeoutInMins, alfrescoBaseUrl, pageSize);
    }

    AlfrescoClient(WebClient webClient, ObjectMapper objectMapper, AuthService authService, int timeoutInMins, String alfrescoBaseUrl, int pageSize) {
        this.webClient = webClient;
        this.objectMapper = objectMapper;
        this.authService = authService;
        this.timeoutInMins = timeoutInMins;
        this.alfrescoBaseUrl = alfrescoBaseUrl;
        this.pageSize = pageSize;
    }

    public List<AlfrescoUser> getAllUsers() {
        return this.fetchAllPagedData("/people", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, "users");
    }

    public List<AlfrescoGroup> getAllGroups() {
        return this.fetchAllPagedData("/groups", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, "groups");
    }

    public List<String> getUserGroups(String userId) {
        List groups = this.fetchAllPagedData("/people/" + userId + "/groups", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, "groups for user " + userId);
        return groups.stream().map(AlfrescoGroup::getId).toList();
    }

    private <T> List<T> fetchAllPagedData(String basePath, TypeReference<AlfrescoPagedResponse<T>> typeRef, String errorContext) {
        try {
            ArrayList results = new ArrayList();
            int skipCount = 0;
            boolean hasMoreItems = true;
            while (hasMoreItems) {
                AlfrescoPagedResponse.Pagination pagination;
                String response = (String)this.makeAuthenticatedRequest(basePath + "?maxItems=" + this.pageSize + "&skipCount=" + skipCount).bodyToMono(String.class).block(Duration.ofMinutes(this.timeoutInMins));
                AlfrescoPagedResponse pagedResponse = (AlfrescoPagedResponse)this.objectMapper.readValue(response, typeRef);
                if (pagedResponse.getList() != null && pagedResponse.getList().getEntries() != null) {
                    pagedResponse.getList().getEntries().stream().map(AlfrescoPagedResponse.EntryWrapper::getEntry).filter(entry -> entry != null).forEach(results::add);
                }
                if ((pagination = pagedResponse.getList().getPagination()) != null) {
                    hasMoreItems = pagination.isHasMoreItems();
                    skipCount += pagination.getCount();
                    continue;
                }
                hasMoreItems = false;
            }
            return results;
        }
        catch (Exception e) {
            LOGGER.error("Error fetching " + errorContext + ": {}", (Object)e.getMessage(), (Object)e);
            throw new ClientException("Failed to fetch " + errorContext, (Throwable)e);
        }
    }

    @Retryable(retryFor={EndpointServerErrorException.class}, maxAttemptsExpression="#{${http-client.max-attempts:3}}", backoff=@Backoff(delayExpression="#{${http-client.initial-delay-ms:2000}}", multiplierExpression="#{${http-client.multiplier:2}}", maxDelayExpression="#{${http-client.max-delay-ms:10000}}"))
    private WebClient.ResponseSpec makeAuthenticatedRequest(String path) {
        Map headers = this.authService.getAlfrescoAuthHeaders();
        return this.webClient.get().uri(this.alfrescoBaseUrl + path, new Object[0]).headers(httpHeaders -> headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).set(arg_0, arg_1))).retrieve();
    }
}

