/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.prediction_applier.config;

import java.util.Map;
import org.alfresco.hxi_connector.common.adapters.auth.AccessTokenProvider;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.adapters.auth.AuthenticationClient;
import org.alfresco.hxi_connector.common.adapters.auth.DefaultAccessTokenProvider;
import org.alfresco.hxi_connector.common.adapters.auth.config.properties.AuthProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableRetry
@EnableConfigurationProperties
public class AuthConfig {
    public static final String HXAI_ENVIRONMENT_HEADER = "hxai-environment";

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity security) throws Exception {
        return (SecurityFilterChain)security.formLogin(AbstractHttpConfigurer::disable).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/actuator/health/**"})).permitAll()).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).denyAll()).build();
    }

    @Bean
    public AccessTokenProvider defaultAccessTokenProvider(AuthenticationClient predictionApplierHxAuthClient) {
        return new DefaultAccessTokenProvider(predictionApplierHxAuthClient);
    }

    @Bean
    @ConfigurationProperties(prefix="auth")
    public AuthProperties authorizationProperties() {
        return new AuthProperties();
    }

    @Bean
    public AuthService authService(AuthProperties authProperties, AccessTokenProvider defaultAccessTokenProvider) {
        return new AuthService(authProperties, defaultAccessTokenProvider){

            protected Map.Entry<String, String> getHxpEnvironmentHeader() {
                return Map.entry(AuthConfig.HXAI_ENVIRONMENT_HEADER, (String)super.getHxpEnvironmentHeader().getValue());
            }
        };
    }
}

