/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.prediction_applier.repository;

import com.fasterxml.jackson.core.io.JsonEOFException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.alfresco.hxi_connector.common.util.ErrorUtils;
import org.alfresco.hxi_connector.prediction_applier.config.RepositoryApiProperties;
import org.alfresco.hxi_connector.prediction_applier.model.repository.PredictionModelResponse;
import org.alfresco.hxi_connector.prediction_applier.util.LinkedListJacksonDataFormat;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.http.HttpMethods;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.builder.PredicateBuilder;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.core5.http.MalformedChunkCodingException;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.springframework.stereotype.Component;

@Component
public class NodesClient
extends RouteBuilder {
    public static final String NODES_DIRECT_ENDPOINT = "direct:" + NodesClient.class.getSimpleName();
    private static final String RETRYABLE_ROUTE = "direct:retryable-" + NodesClient.class.getSimpleName();
    static final String ROUTE_ID = "repository-nodes";
    public static final String NODE_ID_HEADER = "nodeId";
    private static final String URI_PATTERN = "%s/api/-default-/private/hxi/versions/1/nodes/${headers.nodeId}/predictions?httpMethod=POST&throwExceptionOnFailure=false";
    private static final int EXPECTED_STATUS_CODE = 201;
    public static final String UNEXPECTED_STATUS_CODE_MESSAGE = "Unexpected response status code - expecting: %d, received: %d";
    private static final Set<Class<? extends Throwable>> RETRY_REASONS = Set.of(EndpointServerErrorException.class, UnknownHostException.class, JsonEOFException.class, MismatchedInputException.class, HttpHostConnectException.class, NoHttpResponseException.class, MalformedChunkCodingException.class);
    private final RepositoryApiProperties repositoryApiProperties;
    private final AuthService authService;

    public void configure() {
        ((OnExceptionDefinition)this.onException((Class[])RETRY_REASONS.toArray(Class[]::new)).retryAttemptedLogLevel(LoggingLevel.WARN).logExhaustedMessageBody(true).log(LoggingLevel.ERROR, this.log, "Unexpected response. Headers: ${headers}, Body: ${body}")).maximumRedeliveries(this.repositoryApiProperties.retry().attempts()).redeliveryDelay((long)this.repositoryApiProperties.retry().initialDelay()).backOffMultiplier(this.repositoryApiProperties.retry().delayMultiplier()).stop();
        ((OnExceptionDefinition)this.onException(Exception.class).log(LoggingLevel.ERROR, this.log, "Unexpected response. Headers: ${headers}, Body: ${body}")).stop();
        ((RouteDefinition)this.from(NODES_DIRECT_ENDPOINT).marshal().json(JsonLibrary.Jackson).to(RETRYABLE_ROUTE)).end();
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(RETRYABLE_ROUTE).id(ROUTE_ID)).errorHandler((ErrorHandlerFactory)this.noErrorHandler()).setHeader("CamelHttpMethod", (Expression)this.constant((Object)HttpMethods.PUT))).process(arg_0 -> ((AuthService)this.authService).setAlfrescoAuthorizationHeaders(arg_0))).log(LoggingLevel.DEBUG, this.log, "Prediction :: applying to node: ${headers.nodeId}")).toD(URI_PATTERN.formatted(this.repositoryApiProperties.baseUrl()))).choice().when(this.header("CamelHttpResponseCode").isNotEqualTo((Object)String.valueOf(201))).process(arg_0 -> this.throwExceptionOnUnexpectedStatusCode(arg_0))).otherwise().choice().when(this.body().startsWith((Object)"[")).unmarshal((DataFormat)new LinkedListJacksonDataFormat(PredictionModelResponse.class))).otherwise().unmarshal().json(JsonLibrary.Jackson, PredictionModelResponse.class).setBody(exchange -> List.of((PredictionModelResponse)exchange.getIn().getBody(PredictionModelResponse.class)))).end().choice().when(this.bodyNotEmpty()).log(LoggingLevel.DEBUG, this.log, "Prediction :: successfully applied to node: ${headers.nodeId}")).otherwise().log(LoggingLevel.INFO, this.log, "Prediction :: failed to apply to node: ${headers.nodeId}")).log(LoggingLevel.TRACE, this.log, "Headers: ${headers}")).end().end();
    }

    private Predicate bodyNotEmpty() {
        return PredicateBuilder.and((Predicate)this.body().isNotNull(), (Predicate)this.bodyAs(Collection.class).method("isEmpty").isEqualTo((Object)false));
    }

    private void throwExceptionOnUnexpectedStatusCode(Exchange exchange) {
        int actualStatusCode = (Integer)exchange.getMessage().getHeader("CamelHttpResponseCode", Integer.class);
        if (actualStatusCode != 201) {
            this.log.warn(UNEXPECTED_STATUS_CODE_MESSAGE.formatted(201, actualStatusCode));
        }
        ErrorUtils.throwExceptionOnUnexpectedStatusCode((int)actualStatusCode, (int)201);
    }

    @Generated
    public NodesClient(RepositoryApiProperties repositoryApiProperties, AuthService authService) {
        this.repositoryApiProperties = repositoryApiProperties;
        this.authService = authService;
    }
}

