/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Mac;
import org.alfresco.encryption.Encryptor;
import org.alfresco.encryption.KeyProvider;
import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MACUtils {
    private static Log logger = LogFactory.getLog(Encryptor.class);
    private static byte SEPARATOR = 0;
    private final ThreadLocal<Mac> threadMac = new ThreadLocal();
    private KeyProvider keyProvider;
    private String macAlgorithm;

    public void setKeyProvider(KeyProvider keyProvider) {
        this.keyProvider = keyProvider;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    protected Mac getMac(String keyAlias) throws Exception {
        Key key;
        Mac mac = this.threadMac.get();
        if (mac == null) {
            mac = Mac.getInstance(this.macAlgorithm);
            this.threadMac.set(mac);
        }
        if ((key = this.keyProvider.getKey(keyAlias)) == null) {
            throw new AlfrescoRuntimeException("Unexpected null key for key alias " + keyAlias);
        }
        mac.init(key);
        return mac;
    }

    protected byte[] longToByteArray(long l) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeLong(l);
        dos.flush();
        return bos.toByteArray();
    }

    public byte[] generateMAC(String keyAlias, MACInput macInput) {
        try {
            int len;
            InputStream fullMessage = macInput.getMACInput();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Generating MAC for " + macInput + "..."));
            }
            Mac mac = this.getMac(keyAlias);
            byte[] buf = new byte[1024];
            while ((len = fullMessage.read(buf, 0, 1024)) != -1) {
                mac.update(buf, 0, len);
            }
            byte[] newMAC = mac.doFinal();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("...done. MAC is " + Arrays.toString(newMAC)));
            }
            return newMAC;
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Failed to generate MAC", e);
        }
    }

    public boolean validateMAC(String keyAlias, byte[] expectedMAC, MACInput macInput) {
        try {
            byte[] mac = this.generateMAC(keyAlias, macInput);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Validating expected MAC " + Arrays.toString(expectedMAC) + " against mac " + Arrays.toString(mac) + " for MAC input " + macInput + "..."));
            }
            boolean areEqual = Arrays.equals(expectedMAC, mac);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(areEqual ? "...MAC validation succeeded." : "...MAC validation failed."));
            }
            return areEqual;
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Failed to validate MAC", e);
        }
    }

    public static class MACInput {
        private InputStream message;
        private long timestamp;
        private String ipAddress;

        public MACInput(byte[] message, long timestamp, String ipAddress) {
            this.message = message != null ? new ByteArrayInputStream(message) : null;
            this.timestamp = timestamp;
            this.ipAddress = ipAddress;
        }

        public InputStream getMessage() {
            return this.message;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public InputStream getMACInput() throws IOException {
            ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bytes);
            out.writeUTF(this.ipAddress);
            out.writeByte(SEPARATOR);
            out.writeLong(this.timestamp);
            inputStreams.add(new ByteArrayInputStream(bytes.toByteArray()));
            if (this.message != null) {
                inputStreams.add(this.message);
            }
            return new MessageInputStream(inputStreams);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MACInput[");
            sb.append("timestamp: ").append(this.getTimestamp());
            sb.append("ipAddress: ").append(this.getIpAddress());
            return sb.toString();
        }
    }

    private static class MessageInputStream
    extends InputStream {
        private List<InputStream> input;
        private InputStream activeInputStream;
        private int currentStream = 0;

        public MessageInputStream(List<InputStream> input) {
            this.input = input;
            this.currentStream = 0;
            this.activeInputStream = input.get(this.currentStream);
        }

        @Override
        public void close() throws IOException {
            IOException firstIOException = null;
            for (InputStream in : this.input) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    if (firstIOException != null) continue;
                    firstIOException = e;
                }
            }
            if (firstIOException != null) {
                throw firstIOException;
            }
        }

        @Override
        public int read() throws IOException {
            int i = this.activeInputStream.read();
            if (i == -1) {
                ++this.currentStream;
                if (this.currentStream >= this.input.size()) {
                    return -1;
                }
                this.activeInputStream = this.input.get(this.currentStream);
                i = this.activeInputStream.read();
            }
            return i;
        }
    }
}

