/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.alfresco.encryption.AlfrescoKeyStore;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Log logger = LogFactory.getLog(AuthSSLProtocolSocketFactory.class);
    private SSLContext sslcontext = null;
    private AlfrescoKeyStore keyStore = null;
    private AlfrescoKeyStore trustStore = null;

    public AuthSSLProtocolSocketFactory(AlfrescoKeyStore sslKeyStore, AlfrescoKeyStore sslTrustStore, KeyResourceLoader keyResourceLoader) {
        this.keyStore = sslKeyStore;
        this.trustStore = sslTrustStore;
    }

    private SSLContext createSSLContext() {
        KeyManager[] keymanagers = this.keyStore.createKeyManagers();
        TrustManager[] trustmanagers = this.trustStore.createTrustManagers();
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(keymanagers, trustmanagers, null);
            return sslcontext;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to create SSL context", e);
        }
    }

    private SSLContext getSSLContext() {
        try {
            if (this.sslcontext == null) {
                this.sslcontext = this.createSSLContext();
            }
            return this.sslcontext;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to create SSL context", e);
        }
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocket sslSocket = null;
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (timeout == 0) {
            sslSocket = (SSLSocket)socketfactory.createSocket(host, port, localAddress, localPort);
        } else {
            sslSocket = (SSLSocket)socketfactory.createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            sslSocket.bind(localaddr);
            sslSocket.connect(remoteaddr, timeout);
        }
        return sslSocket;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
        return sslSocket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port);
        return sslSocket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
        return sslSocket;
    }
}

