/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import org.alfresco.error.AlfrescoRuntimeException;

public class PropertyCheck {
    public static final String ERR_PROPERTY_NOT_SET = "system.err.property_not_set";

    public static void mandatory(Object target, String propertyName, Object value) {
        if (value == null) {
            throw new AlfrescoRuntimeException(ERR_PROPERTY_NOT_SET, new Object[]{propertyName, target, target.getClass()});
        }
    }

    public static boolean isValidPropertyString(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return !value.startsWith("${") || !value.endsWith("}");
    }

    public static String getPropertyName(String value) {
        if (value == null) {
            throw new IllegalArgumentException("'value' is a required argument.");
        }
        if (!value.startsWith("${")) {
            return value;
        }
        if (!value.endsWith("}")) {
            return value;
        }
        int strLen = value.length();
        return value.substring(2, strLen - 1);
    }
}

