/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.exec;

import java.util.Collections;
import java.util.List;
import org.alfresco.util.exec.RuntimeExec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class RuntimeExecShutdownBean
extends AbstractLifecycleBean {
    private static Log logger = LogFactory.getLog(RuntimeExecShutdownBean.class);
    private List<RuntimeExec> shutdownCommands = Collections.emptyList();
    private Thread shutdownHook;
    private boolean executed = false;

    public void setShutdownCommands(List<RuntimeExec> startupCommands) {
        this.shutdownCommands = startupCommands;
    }

    private synchronized void execute() {
        if (this.executed) {
            return;
        }
        this.executed = true;
        for (RuntimeExec command : this.shutdownCommands) {
            RuntimeExec.ExecutionResult result = command.execute();
            if (result.getSuccess()) continue;
            logger.error((Object)("Shutdown command execution failed.  Continuing with other commands.: \n" + result));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Executed shutdown commands");
        }
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.shutdownHook = new ShutdownThread();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Registered shutdown hook");
        }
    }

    protected void onShutdown(ApplicationEvent event) {
        if (this.shutdownHook != null) {
            this.execute();
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.shutdownHook = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Deregistered shutdown hook");
            }
        }
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
            super(RuntimeExecShutdownBean.class.getName());
            this.setDaemon(true);
        }

        @Override
        public void run() {
            RuntimeExecShutdownBean.this.execute();
        }
    }
}

