/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.transaction;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.alfresco.error.StackTraceUtil;
import org.alfresco.util.GUID;
import org.alfresco.util.transaction.ConnectionPoolException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringAwareUserTransaction
extends TransactionAspectSupport
implements UserTransaction,
TransactionAttributeSource,
TransactionAttribute {
    private static final long serialVersionUID = 3762538897183224373L;
    private static final String NAME = "UserTransaction";
    private static final Log logger = LogFactory.getLog(SpringAwareUserTransaction.class);
    private static final Log traceLogger = LogFactory.getLog((String)(SpringAwareUserTransaction.class.getName() + ".trace"));
    private static volatile boolean isCallStackTraced = false;
    private boolean isBeginMatched = true;
    private StackTraceElement[] beginCallStack;
    private boolean readOnly;
    private int isolationLevel;
    private int propagationBehaviour;
    private int timeout;
    private int internalStatus = 6;
    private TransactionAspectSupport.TransactionInfo internalTxnInfo;
    private long threadId = Long.MIN_VALUE;
    private boolean finalized = false;
    private Collection<String> labels = Collections.emptyList();

    static boolean isCallStackTraced() {
        return isCallStackTraced;
    }

    public SpringAwareUserTransaction(PlatformTransactionManager transactionManager, boolean readOnly, int isolationLevel, int propagationBehaviour, int timeout) {
        this.setTransactionManager((TransactionManager)transactionManager);
        this.setTransactionAttributeSource(this);
        this.readOnly = readOnly;
        this.isolationLevel = isolationLevel;
        this.propagationBehaviour = propagationBehaviour;
        this.timeout = timeout;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(NAME).append("[object=").append(super.toString()).append(", status=").append(this.internalStatus).append("]");
        return sb.toString();
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class<?> targetClass) {
        return this;
    }

    public String getQualifier() {
        return null;
    }

    public void setLabels(Collection<String> labels) {
        this.labels = labels;
    }

    public Collection<String> getLabels() {
        return this.labels;
    }

    public boolean rollbackOn(Throwable ex) {
        return true;
    }

    public String getName() {
        return Thread.currentThread().getName() + "-" + GUID.generate();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public int getPropagationBehavior() {
        return this.propagationBehaviour;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        if (this.internalStatus != 6) {
            throw new RuntimeException("Can only set the timeout before begin");
        }
        this.timeout = timeout;
    }

    private TransactionAspectSupport.TransactionInfo getTransactionInfo() {
        if (this.threadId < 0L && this.internalStatus != 6) {
            throw new RuntimeException("Transaction has been started but there is no thread ID");
        }
        if (this.threadId >= 0L && this.internalStatus == 6) {
            throw new RuntimeException("Transaction has not been started but a thread ID has been recorded");
        }
        TransactionAspectSupport.TransactionInfo txnInfo = null;
        try {
            txnInfo = TransactionAspectSupport.currentTransactionInfo();
        }
        catch (NoTransactionException noTransactionException) {
            // empty catch block
        }
        if (this.internalStatus == 0) {
            if (Thread.currentThread().getId() != this.threadId) {
                throw new RuntimeException("UserTransaction may not be accessed by multiple threads");
            }
            if (txnInfo == null) {
                throw new RuntimeException("Transaction boundaries have been made to overlap in the stack");
            }
            if (txnInfo != this.internalTxnInfo) {
                throw new RuntimeException("UserTransaction begin/commit mismatch");
            }
        }
        return txnInfo;
    }

    public synchronized int getStatus() throws SystemException {
        TransactionAspectSupport.TransactionInfo txnInfo = this.getTransactionInfo();
        if (txnInfo == null) {
            return this.internalStatus;
        }
        TransactionStatus txnStatus = txnInfo.getTransactionStatus();
        if (this.internalStatus == 4) {
            return this.internalStatus;
        }
        if (txnStatus.isRollbackOnly()) {
            return 1;
        }
        return this.internalStatus;
    }

    public synchronized void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionAspectSupport.TransactionInfo txnInfo = this.getTransactionInfo();
        int status = this.getStatus();
        if (status != 1) {
            if (status == 6) {
                throw new IllegalStateException("The transaction has not been started yet");
            }
            if (status == 9 || status == 4) {
                throw new IllegalStateException("The transaction has already been rolled back");
            }
            if (status == 8 || status == 3) {
                throw new IllegalStateException("The transaction has already been committed");
            }
            if (status != 0) {
                throw new IllegalStateException("The transaction is not active: " + status);
            }
        }
        txnInfo.getTransactionStatus().setRollbackOnly();
        this.internalStatus = 1;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set transaction status to rollback only: " + this));
        }
    }

    public synchronized void begin() throws NotSupportedException, SystemException {
        TransactionAspectSupport.TransactionInfo txnInfo = this.getTransactionInfo();
        if (this.internalStatus != 6) {
            throw new NotSupportedException("The UserTransaction may not be reused");
        }
        if (this.propagationBehaviour != 3 && !this.readOnly && TransactionSynchronizationManager.isSynchronizationActive() && TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
            throw new IllegalStateException("Nested writable transaction in a read only transaction");
        }
        try {
            TransactionManager tm = this.getTransactionManager();
            if (tm != null && !(tm instanceof PlatformTransactionManager)) {
                throw new IllegalStateException("Specified transaction manager is not a PlatformTransactionManager: " + tm);
            }
            this.internalTxnInfo = this.createTransactionIfNecessary((PlatformTransactionManager)tm, this.getTransactionAttribute(null, null), this.getName());
        }
        catch (CannotCreateTransactionException e) {
            throw new ConnectionPoolException("The DB connection pool is depleted.", e);
        }
        this.internalStatus = 0;
        this.threadId = Thread.currentThread().getId();
        this.isBeginMatched = false;
        if (isCallStackTraced) {
            Exception e = new Exception();
            e.fillInStackTrace();
            this.beginCallStack = e.getStackTrace();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Began user transaction: " + this));
        }
    }

    public synchronized void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionAspectSupport.TransactionInfo txnInfo = this.getTransactionInfo();
        int status = this.getStatus();
        if (status == 6) {
            throw new IllegalStateException("The transaction has not yet begun");
        }
        if (status == 9 || status == 4) {
            throw new RollbackException("The transaction has already been rolled back");
        }
        if (status == 1) {
            throw new RollbackException("The transaction has already been marked for rollback");
        }
        if (status == 8 || status == 3) {
            throw new IllegalStateException("The transaction has already been committed");
        }
        if (status != 0 || txnInfo == null) {
            throw new IllegalStateException("No user transaction is active");
        }
        if (!this.finalized) {
            try {
                this.commitTransactionAfterReturning(txnInfo);
            }
            catch (Throwable e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Transaction didn't commit", e);
                }
                this.internalStatus = 4;
                RollbackException re = new RollbackException("Transaction didn't commit: " + e.getMessage());
                re.initCause(e);
                throw re;
            }
            finally {
                this.cleanupTransactionInfo(txnInfo);
                this.finalized = true;
                this.isBeginMatched = true;
                this.beginCallStack = null;
            }
        }
        this.internalStatus = 3;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Committed user transaction: " + this));
        }
    }

    public synchronized void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionAspectSupport.TransactionInfo txnInfo = this.getTransactionInfo();
        int status = this.getStatus();
        if (status == 9 || status == 4) {
            throw new IllegalStateException("The transaction has already been rolled back");
        }
        if (status == 8 || status == 3) {
            throw new IllegalStateException("The transaction has already been committed");
        }
        if (txnInfo == null) {
            throw new IllegalStateException("No user transaction is active");
        }
        if (!this.finalized) {
            try {
                this.completeTransactionAfterThrowing(txnInfo, new Exception());
            }
            finally {
                this.cleanupTransactionInfo(txnInfo);
                this.finalized = true;
                this.isBeginMatched = true;
                this.beginCallStack = null;
            }
        }
        this.internalStatus = 4;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rolled back user transaction: " + this));
        }
    }

    protected void completeTransactionAfterThrowing(TransactionAspectSupport.TransactionInfo txInfo, Throwable ex) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exception attempting to pass transaction boundaries.", ex);
        }
        super.completeTransactionAfterThrowing(txInfo, ex);
    }

    protected void finalize() throws Throwable {
        if (!this.isBeginMatched) {
            if (isCallStackTraced) {
                if (this.beginCallStack == null) {
                    traceLogger.error((Object)"UserTransaction being garbage collected without a commit() or rollback(). NOTE: Prior to transaction call stack logging.");
                } else {
                    StringBuilder sb = new StringBuilder(1024);
                    StackTraceUtil.buildStackTrace("UserTransaction being garbage collected without a commit() or rollback().", this.beginCallStack, sb, -1);
                    traceLogger.error((Object)sb);
                }
            } else {
                traceLogger.error((Object)"Detected first UserTransaction which is being garbage collected without a commit() or rollback()");
                traceLogger.error((Object)"Logging of transaction call stack is now enabled and will affect performance");
                isCallStackTraced = true;
            }
        }
    }

    static {
        if (traceLogger.isDebugEnabled()) {
            isCallStackTraced = true;
            traceLogger.warn((Object)"Logging of transaction call stack is enforced and will affect performance");
        }
    }
}

