/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.IOException;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextAwareQuery
extends Query {
    protected static final Logger log = LoggerFactory.getLogger(ContextAwareQuery.class);
    private final Query luceneQuery;
    private final SearchParameters searchParameters;

    public ContextAwareQuery(Query luceneQuery, SearchParameters searchParameters) {
        this.luceneQuery = luceneQuery;
        this.searchParameters = searchParameters;
    }

    public String toString(String field) {
        return this.luceneQuery.toString(field);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScore) throws IOException {
        return this.luceneQuery.createWeight(searcher, needsScore);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this.luceneQuery.rewrite(reader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContextAwareQuery)) {
            return false;
        }
        ContextAwareQuery that = (ContextAwareQuery)((Object)o);
        if (this.luceneQuery != null ? !this.luceneQuery.equals((Object)that.luceneQuery) : that.luceneQuery != null) {
            return false;
        }
        return this.searchParameters != null ? this.searchParameters.equals((Object)that.searchParameters) : that.searchParameters == null;
    }

    public int hashCode() {
        int result = this.luceneQuery != null ? this.luceneQuery.hashCode() : 0;
        result = 31 * result + (this.searchParameters != null ? this.searchParameters.hashCode() : 0);
        return result;
    }

    public Query getLuceneQuery() {
        return this.luceneQuery;
    }
}

