/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.Lists;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CachingDirectoryFactory;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MergeIndexesOp
implements CoreAdminHandler.CoreAdminOp {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    MergeIndexesOp() {
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        SolrParams params = it.req.getParams();
        String cname = params.required().get("core");
        SolrCore core = it.handler.coreContainer.getCore(cname);
        SolrQueryRequest wrappedReq = null;
        ArrayList sourceCores = Lists.newArrayList();
        ArrayList searchers = Lists.newArrayList();
        ArrayList readersToBeClosed = Lists.newArrayList();
        HashMap<Directory, Boolean> dirsToBeReleased = new HashMap<Directory, Boolean>();
        if (core != null) {
            try {
                int i;
                String[] dirNames = params.getParams("indexDir");
                if (dirNames == null || dirNames.length == 0) {
                    String[] sources = params.getParams("srcCore");
                    if (sources == null || sources.length == 0) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one indexDir or srcCore must be specified");
                    }
                    for (i = 0; i < sources.length; ++i) {
                        String source = sources[i];
                        SolrCore srcCore = it.handler.coreContainer.getCore(source);
                        if (srcCore == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core: " + source + " does not exist");
                        }
                        sourceCores.add(srcCore);
                    }
                } else {
                    DirectoryFactory dirFactory = core.getDirectoryFactory();
                    for (i = 0; i < dirNames.length; ++i) {
                        boolean markAsDone = false;
                        if (dirFactory instanceof CachingDirectoryFactory && !((CachingDirectoryFactory)dirFactory).getLivePaths().contains(dirNames[i])) {
                            markAsDone = true;
                        }
                        Directory dir = dirFactory.get(dirNames[i], DirectoryFactory.DirContext.DEFAULT, core.getSolrConfig().indexConfig.lockType);
                        dirsToBeReleased.put(dir, markAsDone);
                        readersToBeClosed.add(DirectoryReader.open((Directory)dir));
                    }
                }
                ArrayList readers = null;
                if (readersToBeClosed.size() > 0) {
                    readers = readersToBeClosed;
                } else {
                    readers = Lists.newArrayList();
                    for (SolrCore solrCore : sourceCores) {
                        RefCounted<SolrIndexSearcher> searcher = solrCore.getSearcher();
                        searchers.add(searcher);
                        readers.add(searcher.get().getIndexReader());
                    }
                }
                UpdateRequestProcessorChain processorChain = core.getUpdateProcessingChain(params.get("update.chain"));
                wrappedReq = new LocalSolrQueryRequest(core, it.req.getParams());
                UpdateRequestProcessor processor = processorChain.createProcessor(wrappedReq, it.rsp);
                processor.processMergeIndexes(new MergeIndexesCommand(readers, it.req));
            }
            catch (Exception e) {
                log.error("ERROR executing merge:", (Throwable)e);
                throw e;
            }
            finally {
                for (RefCounted searcher : searchers) {
                    if (searcher == null) continue;
                    searcher.decref();
                }
                for (SolrCore solrCore : sourceCores) {
                    if (solrCore == null) continue;
                    solrCore.close();
                }
                IOUtils.closeWhileHandlingException((Iterable)readersToBeClosed);
                Set entries = dirsToBeReleased.entrySet();
                for (Map.Entry entry : entries) {
                    DirectoryFactory dirFactory = core.getDirectoryFactory();
                    Directory dir = (Directory)entry.getKey();
                    boolean markAsDone = (Boolean)entry.getValue();
                    if (markAsDone) {
                        dirFactory.doneWithDirectory(dir);
                    }
                    dirFactory.release(dir);
                }
                if (wrappedReq != null) {
                    wrappedReq.close();
                }
                core.close();
            }
        }
    }
}

