/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocList;
import org.apache.solr.util.SolrPluginUtils;

public abstract class SolrHighlighter {
    public static int DEFAULT_MAX_CHARS = 51200;
    public static int DEFAULT_PHRASE_LIMIT = 5000;

    public boolean isHighlightingEnabled(SolrParams params) {
        return params.getBool("hl", false);
    }

    public String[] getHighlightFields(Query query, SolrQueryRequest request, String[] defaultFields) {
        String[] fields = request.getParams().getParams("hl.fl");
        if (this.emptyArray(fields)) {
            if (this.emptyArray(defaultFields)) {
                String[] stringArray;
                String defaultSearchField = request.getSchema().getDefaultSearchFieldName();
                if (null == defaultSearchField) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = defaultSearchField;
                }
                fields = stringArray;
            } else {
                fields = defaultFields;
            }
        } else {
            LinkedHashSet<String> expandedFields = new LinkedHashSet<String>();
            Collection<String> storedHighlightFieldNames = request.getSearcher().getDocFetcher().getStoredHighlightFieldNames();
            for (String field : fields) {
                SolrHighlighter.expandWildcardsInHighlightFields(expandedFields, storedHighlightFieldNames, SolrPluginUtils.split(field));
            }
            fields = expandedFields.toArray(new String[0]);
        }
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = fields[i].trim();
        }
        return fields;
    }

    protected boolean emptyArray(String[] arr) {
        return arr == null || arr.length == 0 || arr[0] == null || arr[0].trim().length() == 0;
    }

    private static void expandWildcardsInHighlightFields(Set<String> expandedFields, Collection<String> storedHighlightFieldNames, String ... fields) {
        for (String field : fields) {
            if (field.contains("*")) {
                String fieldRegex = field.replaceAll("\\*", ".*");
                for (String storedFieldName : storedHighlightFieldNames) {
                    if (!storedFieldName.matches(fieldRegex)) continue;
                    expandedFields.add(storedFieldName);
                }
                continue;
            }
            expandedFields.add(field);
        }
    }

    public abstract NamedList<Object> doHighlighting(DocList var1, Query var2, SolrQueryRequest var3, String[] var4) throws IOException;
}

