/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.parsers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.search.adaptor.AnalysisMode;
import org.alfresco.repo.search.impl.parsers.FTSLexer;
import org.alfresco.repo.search.impl.parsers.FTSParser;
import org.alfresco.repo.search.impl.parsers.FTSQueryException;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.Column;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.Function;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.LiteralArgument;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.QueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.impl.querymodel.Selector;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.util.ISO9075;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class FTSQueryParser {
    private static TestNodeBuilder testNodeBuilder = new TestNodeBuilder();
    static final String KEY_REPLACELONESTAR = "KEY_REPLACELONESTAR";
    static final String VALUE_REPLACELONESTAR = "ISNODE:T";

    public static void setTestNodeBuilder(TestNodeBuilder tnb) {
        testNodeBuilder = tnb;
    }

    public static Constraint buildFTS(String ftsExpression, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap, FTSParser.Mode mode, QueryOptions.Connective defaultFieldConnective, Map<String, String> templates, String defaultField, RerankPhase rerankPhase) {
        HashMap<String, CommonTree> templateTrees = new HashMap<String, CommonTree>();
        if (templates == null) {
            templates = new HashMap<String, String>();
        }
        templates.put(KEY_REPLACELONESTAR, VALUE_REPLACELONESTAR);
        for (String name : templates.keySet()) {
            FTSParser parser = null;
            try {
                String templateDefinition = templates.get(name);
                ANTLRStringStream cs = new ANTLRStringStream(templateDefinition);
                FTSLexer lexer = new FTSLexer((CharStream)cs);
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                parser = new FTSParser((TokenStream)tokens);
                parser.setMode(mode);
                parser.setDefaultFieldConjunction(defaultFieldConnective == QueryOptions.Connective.AND);
                CommonTree ftsNode = (CommonTree)parser.ftsQuery().getTree();
                if (templateTrees.containsKey(name.toLowerCase())) {
                    throw new FTSQueryException("Duplicate template of property: " + name);
                }
                templateTrees.put(name.toLowerCase(), ftsNode);
            }
            catch (RecognitionException e) {
                if (parser != null) {
                    String[] tokenNames = parser.getTokenNames();
                    String hdr = parser.getErrorHeader(e);
                    String msg = parser.getErrorMessage(e, tokenNames);
                    throw new FTSQueryException(hdr + "\n" + msg, e);
                }
                return null;
            }
        }
        FTSParser parser = null;
        try {
            ANTLRStringStream cs = new ANTLRStringStream(ftsExpression);
            FTSLexer lexer = new FTSLexer((CharStream)cs);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            parser = new FTSParser((TokenStream)tokens);
            parser.setMode(mode);
            parser.setDefaultFieldConjunction(defaultFieldConnective == QueryOptions.Connective.AND);
            CommonTree ftsNode = (CommonTree)parser.ftsQuery().getTree();
            if (rerankPhase != RerankPhase.SINGLE_PASS) {
                ftsNode = FTSQueryParser.autoPhraseReWrite(ftsNode, defaultFieldConnective == QueryOptions.Connective.AND, rerankPhase);
            }
            return FTSQueryParser.buildFTSConnective(null, ftsNode, factory, functionEvaluationContext, selector, columnMap, templateTrees, defaultField);
        }
        catch (RecognitionException e) {
            if (parser != null) {
                String[] tokenNames = parser.getTokenNames();
                String hdr = parser.getErrorHeader(e);
                String msg = parser.getErrorMessage(e, tokenNames);
                throw new FTSQueryException(hdr + "\n" + msg, e);
            }
            return null;
        }
    }

    private static CommonTree autoPhraseReWrite(CommonTree node, boolean defaultConjunction, RerankPhase rerankPhase) {
        if (node == null) {
            return node;
        }
        CommonTree newNode = new CommonTree(node);
        if (FTSQueryParser.isAutoPhrasable(node, defaultConjunction)) {
            StringBuilder phrase = new StringBuilder();
            LinkedList<CommonTree> autoPhrased = new LinkedList<CommonTree>();
            for (Object current : node.getChildren()) {
                CommonTree child = (CommonTree)current;
                if (child.getType() == 70 || child.getType() == 17) {
                    if (child.getChildCount() <= 0) continue;
                    CommonTree term = (CommonTree)child.getChild(0);
                    if (term.getType() == 100 && term.getChildCount() == 1) {
                        String termText = FTSQueryParser.getText(term.getChildren());
                        if (phrase.length() > 0) {
                            phrase.append(" ");
                        }
                        phrase.append(termText);
                        autoPhrased.add(child);
                        continue;
                    }
                    CommonTree newChild = FTSQueryParser.autoPhraseReWrite(child, defaultConjunction, rerankPhase);
                    newNode.addChild((Tree)newChild);
                    continue;
                }
                CommonTree newChild = FTSQueryParser.autoPhraseReWrite(child, defaultConjunction, rerankPhase);
                newNode.addChild((Tree)newChild);
            }
            CommonTree disjunction = new CommonTree((Token)new DisjunctionToken());
            newNode.addChild((Tree)disjunction);
            if (rerankPhase == RerankPhase.SINGLE_PASS_WITH_AUTO_PHRASE) {
                CommonTree termConjuctionLink = new CommonTree((Token)new DefaultToken());
                disjunction.addChild((Tree)termConjuctionLink);
                CommonTree termConjunction = new CommonTree((Token)new ConjunctionToken());
                termConjuctionLink.addChild((Tree)termConjunction);
                for (CommonTree phrased : autoPhrased) {
                    CommonTree newPhrased = FTSQueryParser.autoPhraseReWrite(phrased, defaultConjunction, rerankPhase);
                    termConjunction.addChild((Tree)newPhrased);
                }
            }
            CommonTree phraseLink = new CommonTree((Token)new DefaultToken());
            disjunction.addChild((Tree)phraseLink);
            CommonTree phraseTree = new CommonTree((Token)new PhraseToken());
            phraseLink.addChild((Tree)phraseTree);
            phraseTree.addChild((Tree)new CommonTree((Token)new WordToken(phrase.toString())));
        } else if (node.getChildren() != null) {
            for (Object current : node.getChildren()) {
                CommonTree child = (CommonTree)current;
                CommonTree newChild = FTSQueryParser.autoPhraseReWrite(child, defaultConjunction, rerankPhase);
                newNode.addChild((Tree)newChild);
            }
        }
        return newNode;
    }

    private static boolean isAutoPhrasable(CommonTree node, boolean defaultConjunction) {
        if (node.getType() == 12 && node.getChildCount() > 1) {
            int simpleTermCount = 0;
            for (Object current : node.getChildren()) {
                CommonTree child = (CommonTree)current;
                if (child.getType() == 70 || child.getType() == 17) {
                    CommonTree item;
                    if (child.getChildCount() <= 0 || (item = (CommonTree)child.getChild(0)).getType() != 100 || item.getChildCount() != 1) continue;
                    ++simpleTermCount;
                    continue;
                }
                return false;
            }
            return simpleTermCount > 1;
        }
        return false;
    }

    private static Constraint buildFTSConnective(CommonTree fieldReferenceNode, CommonTree node, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap, Map<String, CommonTree> templateTrees, String defaultField) {
        QueryOptions.Connective connective;
        switch (node.getType()) {
            case 19: 
            case 40: {
                connective = QueryOptions.Connective.OR;
                break;
            }
            case 12: 
            case 38: {
                connective = QueryOptions.Connective.AND;
                break;
            }
            default: {
                throw new FTSQueryException("Invalid connective ..." + node.getText());
            }
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>(node.getChildCount());
        for (int i = 0; i < node.getChildCount(); ++i) {
            Constraint constraint;
            CommonTree subNode = (CommonTree)node.getChild(i);
            switch (subNode.getType()) {
                case 12: 
                case 19: 
                case 38: 
                case 40: {
                    constraint = FTSQueryParser.buildFTSConnective(fieldReferenceNode, subNode, factory, functionEvaluationContext, selector, columnMap, templateTrees, defaultField);
                    FTSQueryParser.setBoost(constraint, subNode);
                    break;
                }
                case 44: 
                case 76: {
                    CommonTree testNode = (CommonTree)subNode.getChild(0);
                    constraint = FTSQueryParser.buildFTSTest(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap, templateTrees, defaultField);
                    constraint.setOccur(Constraint.Occur.EXCLUDE);
                    FTSQueryParser.setBoost(constraint, subNode);
                    break;
                }
                case 17: 
                case 39: {
                    CommonTree testNode = (CommonTree)subNode.getChild(0);
                    constraint = FTSQueryParser.buildFTSTest(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap, templateTrees, defaultField);
                    constraint.setOccur(Constraint.Occur.DEFAULT);
                    FTSQueryParser.setBoost(constraint, subNode);
                    break;
                }
                case 43: 
                case 70: {
                    CommonTree testNode = (CommonTree)subNode.getChild(0);
                    constraint = FTSQueryParser.buildFTSTest(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap, templateTrees, defaultField);
                    constraint.setOccur(Constraint.Occur.MANDATORY);
                    FTSQueryParser.setBoost(constraint, subNode);
                    break;
                }
                case 45: 
                case 80: {
                    CommonTree testNode = (CommonTree)subNode.getChild(0);
                    constraint = FTSQueryParser.buildFTSTest(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap, templateTrees, defaultField);
                    constraint.setOccur(Constraint.Occur.OPTIONAL);
                    FTSQueryParser.setBoost(constraint, subNode);
                    break;
                }
                case 28: 
                case 41: {
                    CommonTree testNode = (CommonTree)subNode.getChild(0);
                    constraint = FTSQueryParser.buildFTSTest(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap, templateTrees, defaultField);
                    constraint.setOccur(Constraint.Occur.EXCLUDE);
                    FTSQueryParser.setBoost(constraint, subNode);
                    break;
                }
                default: {
                    throw new FTSQueryException("Unsupported FTS option " + subNode.getText());
                }
            }
            constraints.add(constraint);
        }
        if (constraints.size() == 1 && Constraint.Occur.EXCLUDE != ((Constraint)constraints.get(0)).getOccur()) {
            return (Constraint)constraints.get(0);
        }
        if (connective == QueryOptions.Connective.OR) {
            return factory.createDisjunction(constraints);
        }
        return factory.createConjunction(constraints);
    }

    private static void setBoost(Constraint constraint, CommonTree subNode) {
        int l = subNode.getChildCount();
        for (int i = 0; i < l; ++i) {
            CommonTree child = (CommonTree)subNode.getChild(i);
            if (child.getType() != 8) continue;
            String boostString = child.getChild(0).getText();
            float boost = Float.parseFloat(boostString);
            constraint.setBoost(boost);
            return;
        }
    }

    private static Constraint buildFTSTest(CommonTree fieldReferenceNode, CommonTree argNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap, Map<String, CommonTree> templateTrees, String defaultField) {
        CommonTree testNode = testNodeBuilder.build(fieldReferenceNode, argNode, factory, functionEvaluationContext, selector, columnMap, templateTrees, defaultField);
        Float fuzzy = FTSQueryParser.findFuzzy((Tree)testNode);
        switch (testNode.getType()) {
            case 12: 
            case 19: 
            case 38: 
            case 40: {
                return FTSQueryParser.buildFTSConnective(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap, templateTrees, defaultField);
            }
            case 37: 
            case 100: {
                Tree termNode = testNode.getChild(0);
                if (fuzzy == null) {
                    switch (termNode.getType()) {
                        case 51: {
                            return FTSQueryParser.buildPrefixTerm(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
                        }
                        case 52: 
                        case 88: 
                        case 96: {
                            return FTSQueryParser.buildWildTerm(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
                        }
                    }
                    return FTSQueryParser.buildTerm(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
                }
                switch (termNode.getType()) {
                    case 51: 
                    case 52: 
                    case 88: 
                    case 96: {
                        throw new FTSQueryException("Fuzzy queries are not supported with wild cards");
                    }
                }
                return FTSQueryParser.buildFuzzyTerm(fuzzy, fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
            }
            case 26: 
            case 32: {
                Tree termNode = testNode.getChild(0);
                if (fuzzy == null) {
                    switch (termNode.getType()) {
                        case 51: {
                            return FTSQueryParser.buildExactPrefixTerm(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
                        }
                        case 52: 
                        case 88: 
                        case 96: {
                            return FTSQueryParser.buildExactWildTerm(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
                        }
                    }
                    return FTSQueryParser.buildExactTerm(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
                }
                switch (termNode.getType()) {
                    case 51: 
                    case 52: 
                    case 88: 
                    case 96: {
                        throw new FTSQueryException("Fuzzy queries are not supported with wild cards");
                    }
                }
                return FTSQueryParser.buildFuzzyTerm(fuzzy, fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
            }
            case 33: 
            case 83: {
                return FTSQueryParser.buildPhrase(fuzzy, fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
            }
            case 25: 
            case 31: {
                return FTSQueryParser.buildExactPhrase(fuzzy, fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
            }
            case 36: 
            case 98: {
                Tree termNode = testNode.getChild(0);
                if (fuzzy == null) {
                    switch (termNode.getType()) {
                        case 51: {
                            return FTSQueryParser.buildPrefixTerm(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
                        }
                        case 52: 
                        case 88: 
                        case 96: {
                            return FTSQueryParser.buildWildTerm(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
                        }
                    }
                    return FTSQueryParser.buildExpandTerm(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
                }
                switch (termNode.getType()) {
                    case 51: 
                    case 52: 
                    case 88: 
                    case 96: {
                        throw new FTSQueryException("Fuzzy queries are not supported with wild cards");
                    }
                }
                return FTSQueryParser.buildFuzzyTerm(fuzzy, fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
            }
            case 34: 
            case 86: {
                return FTSQueryParser.buildProximity(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
            }
            case 35: 
            case 89: {
                return FTSQueryParser.buildRange(fieldReferenceNode, testNode, factory, functionEvaluationContext, selector, columnMap);
            }
            case 42: {
                if (fieldReferenceNode != null) {
                    throw new IllegalStateException("Already in field?");
                }
                CommonTree newFieldReferenceNode = (CommonTree)testNode.getChild(0);
                CommonTree fieldExperssion = (CommonTree)testNode.getChild(1);
                return FTSQueryParser.buildFTSConnective(newFieldReferenceNode, fieldExperssion, factory, functionEvaluationContext, selector, columnMap, templateTrees, defaultField);
            }
        }
        throw new FTSQueryException("Unsupported FTS option " + testNode.getText());
    }

    private static Constraint buildRange(CommonTree fieldReferenceNode, CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSRange";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
        LiteralArgument larg = factory.createLiteralArgument("FromInc", DataTypeDefinition.BOOLEAN, Boolean.valueOf(testNode.getChild(0).getType() == 64));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("From", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChild(1))));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("To", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChild(2))));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("ToInc", DataTypeDefinition.BOOLEAN, Boolean.valueOf(testNode.getChild(3).getType() == 64));
        functionArguments.put(larg.getName(), larg);
        if (fieldReferenceNode != null) {
            PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", fieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
            functionArguments.put(parg.getName(), parg);
        } else {
            CommonTree specifiedFieldReferenceNode = FTSQueryParser.findFieldReference(testNode);
            if (specifiedFieldReferenceNode != null) {
                PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", specifiedFieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
                functionArguments.put(parg.getName(), parg);
            }
        }
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static Constraint buildProximity(CommonTree fieldReferenceNode, CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSProximity";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
        LiteralArgument larg = factory.createLiteralArgument("First", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChild(0))));
        functionArguments.put(larg.getName(), larg);
        if (testNode.getChild(1).getChildCount() > 0) {
            larg = factory.createLiteralArgument("Slop", DataTypeDefinition.INT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChild(1).getChild(0))));
            functionArguments.put(larg.getName(), larg);
        }
        larg = factory.createLiteralArgument("Last", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChild(2))));
        functionArguments.put(larg.getName(), larg);
        if (fieldReferenceNode != null) {
            PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", fieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
            functionArguments.put(parg.getName(), parg);
        } else {
            CommonTree specifiedFieldReferenceNode = FTSQueryParser.findFieldReference(testNode);
            if (specifiedFieldReferenceNode != null) {
                PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", specifiedFieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
                functionArguments.put(parg.getName(), parg);
            }
        }
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static Constraint buildExpandTerm(CommonTree fieldReferenceNode, CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSTerm";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
        LiteralArgument larg = factory.createLiteralArgument("Term", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChild(0))));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("TokenisationMode", DataTypeDefinition.ANY, (Serializable)((Object)AnalysisMode.TOKENISE));
        functionArguments.put(larg.getName(), larg);
        if (fieldReferenceNode != null) {
            PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", fieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
            functionArguments.put(parg.getName(), parg);
        } else {
            CommonTree specifiedFieldReferenceNode = FTSQueryParser.findFieldReference(testNode);
            if (specifiedFieldReferenceNode != null) {
                PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", specifiedFieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
                functionArguments.put(parg.getName(), parg);
            }
        }
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static Constraint buildPhrase(Float fuzzy, CommonTree fieldReferenceNode, CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSPhrase";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
        LiteralArgument larg = factory.createLiteralArgument("Phrase", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChild(0))));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("TokenisationMode", DataTypeDefinition.ANY, (Serializable)((Object)AnalysisMode.DEFAULT));
        functionArguments.put(larg.getName(), larg);
        if (fuzzy != null) {
            larg = factory.createLiteralArgument("Slop", DataTypeDefinition.INT, Integer.valueOf(fuzzy.intValue()));
            functionArguments.put(larg.getName(), larg);
        }
        if (fieldReferenceNode != null) {
            PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", fieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
            functionArguments.put(parg.getName(), parg);
        } else {
            CommonTree specifiedFieldReferenceNode = FTSQueryParser.findFieldReference(testNode);
            if (specifiedFieldReferenceNode != null) {
                PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", specifiedFieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
                functionArguments.put(parg.getName(), parg);
            }
        }
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static Constraint buildExactPhrase(Float fuzzy, CommonTree fieldReferenceNode, CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSPhrase";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
        LiteralArgument larg = factory.createLiteralArgument("Phrase", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChild(0))));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("TokenisationMode", DataTypeDefinition.ANY, (Serializable)((Object)AnalysisMode.IDENTIFIER));
        functionArguments.put(larg.getName(), larg);
        if (fuzzy != null) {
            larg = factory.createLiteralArgument("Slop", DataTypeDefinition.INT, Integer.valueOf(fuzzy.intValue()));
            functionArguments.put(larg.getName(), larg);
        }
        if (fieldReferenceNode != null) {
            PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", fieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
            functionArguments.put(parg.getName(), parg);
        } else {
            CommonTree specifiedFieldReferenceNode = FTSQueryParser.findFieldReference(testNode);
            if (specifiedFieldReferenceNode != null) {
                PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", specifiedFieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
                functionArguments.put(parg.getName(), parg);
            }
        }
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static Constraint buildExactTerm(CommonTree fieldReferenceNode, CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSTerm";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
        LiteralArgument larg = factory.createLiteralArgument("Term", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChildren())));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("TokenisationMode", DataTypeDefinition.ANY, (Serializable)((Object)AnalysisMode.IDENTIFIER));
        functionArguments.put(larg.getName(), larg);
        if (fieldReferenceNode != null) {
            PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", fieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
            functionArguments.put(parg.getName(), parg);
        } else {
            CommonTree specifiedFieldReferenceNode = FTSQueryParser.findFieldReference(testNode);
            if (specifiedFieldReferenceNode != null) {
                PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", specifiedFieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
                functionArguments.put(parg.getName(), parg);
            }
        }
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static Constraint buildTerm(CommonTree fieldReferenceNode, CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSTerm";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
        LiteralArgument larg = factory.createLiteralArgument("Term", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChildren())));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("TokenisationMode", DataTypeDefinition.ANY, (Serializable)((Object)AnalysisMode.DEFAULT));
        functionArguments.put(larg.getName(), larg);
        if (fieldReferenceNode != null) {
            PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", fieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
            functionArguments.put(parg.getName(), parg);
        } else {
            CommonTree specifiedFieldReferenceNode = FTSQueryParser.findFieldReference(testNode);
            if (specifiedFieldReferenceNode != null) {
                PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", specifiedFieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
                functionArguments.put(parg.getName(), parg);
            }
        }
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static CommonTree copyAndReplace(CommonTree source, CommonTree insert) {
        CommonTree newNode = new CommonTree(source);
        if (source.getChildCount() > 0) {
            for (Object current : source.getChildren()) {
                CommonTree child = (CommonTree)current;
                if (child.getType() == 99) {
                    if (child.getChildCount() > 1) {
                        CommonTree disjunction = new CommonTree((Token)new DisjunctionToken());
                        newNode.addChild((Tree)disjunction);
                        for (Object currentfieldReferenceNode : child.getChildren()) {
                            CommonTree fieldReferenceNode = (CommonTree)currentfieldReferenceNode;
                            CommonTree def = new CommonTree((Token)new DefaultToken());
                            disjunction.addChild((Tree)def);
                            CommonTree newChild = FTSQueryParser.insertTreeAndFixFieldRefs(insert, fieldReferenceNode);
                            def.addChild((Tree)newChild);
                        }
                        continue;
                    }
                    CommonTree fieldReferenceNode = FTSQueryParser.findFieldReference(child);
                    CommonTree newChild = FTSQueryParser.insertTreeAndFixFieldRefs(insert, fieldReferenceNode);
                    newNode.addChild((Tree)newChild);
                    continue;
                }
                CommonTree newChild = FTSQueryParser.copyAndReplace(child, insert);
                newNode.addChild((Tree)newChild);
            }
        }
        return newNode;
    }

    private static CommonTree copy(CommonTree source) {
        CommonTree newNode = new CommonTree(source);
        if (source.getChildCount() > 0) {
            for (Object current : source.getChildren()) {
                CommonTree child = (CommonTree)current;
                CommonTree newChild = FTSQueryParser.copy(child);
                newNode.addChild((Tree)newChild);
            }
        }
        return newNode;
    }

    private static CommonTree insertTreeAndFixFieldRefs(CommonTree source, CommonTree fieldReferenceNode) {
        boolean foundRef = false;
        CommonTree newNode = new CommonTree(source);
        if (source.getChildCount() > 0) {
            for (Object current : source.getChildren()) {
                CommonTree newChild;
                CommonTree child = (CommonTree)current;
                if (child.getType() == 46) {
                    newChild = FTSQueryParser.copy(fieldReferenceNode);
                    newNode.addChild((Tree)newChild);
                    foundRef = true;
                    continue;
                }
                newChild = FTSQueryParser.insertTreeAndFixFieldRefs(child, fieldReferenceNode);
                newNode.addChild((Tree)newChild);
            }
        }
        if (!foundRef && FTSQueryParser.hasOptionalFieldReference(source)) {
            CommonTree newChild = FTSQueryParser.copy(fieldReferenceNode);
            newNode.addChild((Tree)newChild);
        }
        return newNode;
    }

    private static boolean hasOptionalFieldReference(CommonTree node) {
        switch (node.getType()) {
            case 25: 
            case 26: 
            case 83: 
            case 86: 
            case 89: 
            case 98: 
            case 100: {
                return true;
            }
        }
        return false;
    }

    private static boolean isStarWithNoField(CommonTree testNode) {
        CommonTree child;
        return testNode.getType() == 100 && testNode.getChildCount() == 1 && (child = (CommonTree)testNode.getChild(0)).getType() == 96;
    }

    private static Constraint buildFuzzyTerm(Float fuzzy, CommonTree fieldReferenceNode, CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSFuzzyTerm";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
        LiteralArgument larg = factory.createLiteralArgument("Term", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChild(0))));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("MinSimilarity", DataTypeDefinition.FLOAT, fuzzy);
        functionArguments.put(larg.getName(), larg);
        if (fieldReferenceNode != null) {
            PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", fieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
            functionArguments.put(parg.getName(), parg);
        } else {
            CommonTree specifiedFieldReferenceNode = FTSQueryParser.findFieldReference(testNode);
            if (specifiedFieldReferenceNode != null) {
                PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", specifiedFieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
                functionArguments.put(parg.getName(), parg);
            }
        }
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static Constraint buildWildTerm(CommonTree fieldReferenceNode, CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSWildTerm";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
        LiteralArgument larg = factory.createLiteralArgument("Term", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChildren())));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("TokenisationMode", DataTypeDefinition.ANY, (Serializable)((Object)AnalysisMode.DEFAULT));
        functionArguments.put(larg.getName(), larg);
        if (fieldReferenceNode != null) {
            PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", fieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
            functionArguments.put(parg.getName(), parg);
        } else {
            CommonTree specifiedFieldReferenceNode = FTSQueryParser.findFieldReference(testNode);
            if (specifiedFieldReferenceNode != null) {
                PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", specifiedFieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
                functionArguments.put(parg.getName(), parg);
            }
        }
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static Constraint buildExactWildTerm(CommonTree fieldReferenceNode, CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSWildTerm";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
        LiteralArgument larg = factory.createLiteralArgument("Term", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChildren())));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("TokenisationMode", DataTypeDefinition.ANY, (Serializable)((Object)AnalysisMode.IDENTIFIER));
        functionArguments.put(larg.getName(), larg);
        if (fieldReferenceNode != null) {
            PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", fieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
            functionArguments.put(parg.getName(), parg);
        } else {
            CommonTree specifiedFieldReferenceNode = FTSQueryParser.findFieldReference(testNode);
            if (specifiedFieldReferenceNode != null) {
                PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", specifiedFieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
                functionArguments.put(parg.getName(), parg);
            }
        }
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static Constraint buildPrefixTerm(CommonTree fieldReferenceNode, CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSPrefixTerm";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
        LiteralArgument larg = factory.createLiteralArgument("Term", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChildren())));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("TokenisationMode", DataTypeDefinition.ANY, (Serializable)((Object)AnalysisMode.DEFAULT));
        functionArguments.put(larg.getName(), larg);
        if (fieldReferenceNode != null) {
            PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", fieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
            functionArguments.put(parg.getName(), parg);
        } else {
            CommonTree specifiedFieldReferenceNode = FTSQueryParser.findFieldReference(testNode);
            if (specifiedFieldReferenceNode != null) {
                PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", specifiedFieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
                functionArguments.put(parg.getName(), parg);
            }
        }
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static Constraint buildExactPrefixTerm(CommonTree fieldReferenceNode, CommonTree testNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        String functionName = "FTSPrefixTerm";
        Function function = factory.getFunction(functionName);
        LinkedHashMap<String, Argument> functionArguments = new LinkedHashMap<String, Argument>();
        LiteralArgument larg = factory.createLiteralArgument("Term", DataTypeDefinition.TEXT, (Serializable)((Object)FTSQueryParser.getText(testNode.getChildren())));
        functionArguments.put(larg.getName(), larg);
        larg = factory.createLiteralArgument("TokenisationMode", DataTypeDefinition.ANY, (Serializable)((Object)AnalysisMode.IDENTIFIER));
        functionArguments.put(larg.getName(), larg);
        if (fieldReferenceNode != null) {
            PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", fieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
            functionArguments.put(parg.getName(), parg);
        } else {
            CommonTree specifiedFieldReferenceNode = FTSQueryParser.findFieldReference(testNode);
            if (specifiedFieldReferenceNode != null) {
                PropertyArgument parg = FTSQueryParser.buildFieldReference("Property", specifiedFieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
                functionArguments.put(parg.getName(), parg);
            }
        }
        return factory.createFunctionalConstraint(function, functionArguments);
    }

    private static CommonTree findFieldReference(CommonTree node) {
        int l = node.getChildCount();
        for (int i = 0; i < l; ++i) {
            CommonTree child = (CommonTree)node.getChild(i);
            if (child.getType() != 46) continue;
            return child;
        }
        return null;
    }

    private static Float findFuzzy(Tree node) {
        int l = node.getChildCount();
        for (int i = 0; i < l; ++i) {
            CommonTree child = (CommonTree)node.getChild(i);
            if (child.getType() != 54) continue;
            String fuzzyString = child.getChild(0).getText();
            float fuzzy = Float.parseFloat(fuzzyString);
            return Float.valueOf(fuzzy);
        }
        return null;
    }

    public static PropertyArgument buildFieldReference(String argumentName, CommonTree fieldReferenceNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap) {
        if (fieldReferenceNode.getType() != 46) {
            throw new FTSQueryException("Not column ref  ..." + fieldReferenceNode.getText());
        }
        Object fieldName = FTSQueryParser.getText(fieldReferenceNode.getChild(0));
        if (columnMap != null) {
            for (Column column : columnMap.values()) {
                if (!column.getAlias().equals(fieldName)) continue;
                PropertyArgument arg = (PropertyArgument)column.getFunctionArguments().get("Property");
                fieldName = arg.getPropertyName();
                break;
            }
        }
        if (fieldReferenceNode.getChildCount() > 1) {
            CommonTree child = (CommonTree)fieldReferenceNode.getChild(1);
            if (child.getType() == 85) {
                fieldName = FTSQueryParser.getText(child.getChild(0)) + ":" + (String)fieldName;
            } else if (child.getType() == 75) {
                fieldName = FTSQueryParser.getText(child.getChild(0)) + (String)fieldName;
            }
        }
        String alias = "";
        if (selector != null) {
            functionEvaluationContext.checkFieldApplies(selector, (String)fieldName);
            alias = selector.getAlias();
        }
        return factory.createPropertyArgument(argumentName, functionEvaluationContext.isQueryable((String)fieldName), functionEvaluationContext.isOrderable((String)fieldName), alias, (String)fieldName);
    }

    private static String getText(List<? extends Object> nodes) {
        StringBuilder builder = new StringBuilder();
        for (Object object : nodes) {
            builder.append(FTSQueryParser.getText((Tree)object, false));
        }
        return builder.toString();
    }

    private static String getText(Tree node) {
        return FTSQueryParser.getText(node, true);
    }

    private static String getText(Tree node, boolean returnTextFromUnknownNodes) {
        String text = node.getText();
        switch (node.getType()) {
            case 51: 
            case 52: 
            case 53: {
                int index = text.indexOf(92);
                if (index == -1) {
                    return text;
                }
                return FTSQueryParser.unescape(text);
            }
            case 50: {
                String phrase = text.substring(1, text.length() - 1);
                int index = phrase.indexOf(92);
                if (index == -1) {
                    return phrase;
                }
                return FTSQueryParser.unescape(phrase);
            }
            case 63: {
                int index = text.indexOf(92);
                if (index == -1) {
                    return ISO9075.decode(text);
                }
                return ISO9075.decode(FTSQueryParser.unescape(text));
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 47: 
            case 72: 
            case 78: 
            case 81: 
            case 82: 
            case 84: 
            case 88: 
            case 96: 
            case 101: 
            case 102: 
            case 104: {
                return text;
            }
        }
        if (returnTextFromUnknownNodes) {
            return text;
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String unescape(String string) {
        StringBuilder builder = new StringBuilder(string.length());
        boolean lastWasEscape = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (lastWasEscape) {
                if (c == 'u') {
                    if (i + 4 >= string.length()) throw new UnsupportedOperationException(string);
                    char encoded = (char)Integer.parseInt(string.substring(i + 1, i + 5), 16);
                    builder.append(encoded);
                    i += 4;
                } else {
                    builder.append(c);
                }
                lastWasEscape = false;
                continue;
            }
            if (c == '\\') {
                lastWasEscape = true;
                continue;
            }
            builder.append(c);
        }
        if (!lastWasEscape) return builder.toString();
        throw new FTSQueryException("Escape character at end of string " + string);
    }

    protected static class TestNodeBuilder {
        protected TestNodeBuilder() {
        }

        protected CommonTree build(CommonTree fieldReferenceNode, CommonTree argNode, QueryModelFactory factory, FunctionEvaluationContext functionEvaluationContext, Selector selector, Map<String, Column> columnMap, Map<String, CommonTree> templateTrees, String defaultField) {
            CommonTree template;
            CommonTree testNode = argNode;
            PropertyArgument parg = null;
            if (fieldReferenceNode != null) {
                parg = FTSQueryParser.buildFieldReference("", fieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
            } else {
                CommonTree specifiedFieldReferenceNode = FTSQueryParser.findFieldReference(testNode);
                if (specifiedFieldReferenceNode != null) {
                    parg = FTSQueryParser.buildFieldReference("Property", specifiedFieldReferenceNode, factory, functionEvaluationContext, selector, columnMap);
                }
            }
            if (parg != null) {
                template = templateTrees.get(parg.getPropertyName().toLowerCase());
                if (template != null) {
                    testNode = FTSQueryParser.copyAndReplace(template, testNode);
                }
            } else if (FTSQueryParser.hasOptionalFieldReference(testNode)) {
                if (FTSQueryParser.isStarWithNoField(testNode)) {
                    testNode = FTSQueryParser.copyAndReplace(templateTrees.get(FTSQueryParser.KEY_REPLACELONESTAR.toLowerCase()), testNode);
                } else {
                    template = templateTrees.get(defaultField.toLowerCase());
                    if (template != null) {
                        testNode = FTSQueryParser.copyAndReplace(template, testNode);
                    }
                }
            }
            return testNode;
        }
    }

    public static enum RerankPhase {
        SINGLE_PASS,
        SINGLE_PASS_WITH_AUTO_PHRASE,
        QUERY_PHASE,
        RERANK_PHASE;

    }

    static class DisjunctionToken
    implements Token {
        DisjunctionToken() {
        }

        public int getChannel() {
            return 0;
        }

        public int getCharPositionInLine() {
            return 0;
        }

        public CharStream getInputStream() {
            return null;
        }

        public int getLine() {
            return 0;
        }

        public String getText() {
            return null;
        }

        public int getTokenIndex() {
            return 0;
        }

        public int getType() {
            return 19;
        }

        public void setChannel(int arg0) {
        }

        public void setCharPositionInLine(int arg0) {
        }

        public void setInputStream(CharStream arg0) {
        }

        public void setLine(int arg0) {
        }

        public void setText(String arg0) {
        }

        public void setTokenIndex(int arg0) {
        }

        public void setType(int arg0) {
        }
    }

    static class DefaultToken
    implements Token {
        DefaultToken() {
        }

        public int getChannel() {
            return 0;
        }

        public int getCharPositionInLine() {
            return 0;
        }

        public CharStream getInputStream() {
            return null;
        }

        public int getLine() {
            return 0;
        }

        public String getText() {
            return null;
        }

        public int getTokenIndex() {
            return 0;
        }

        public int getType() {
            return 17;
        }

        public void setChannel(int arg0) {
        }

        public void setCharPositionInLine(int arg0) {
        }

        public void setInputStream(CharStream arg0) {
        }

        public void setLine(int arg0) {
        }

        public void setText(String arg0) {
        }

        public void setTokenIndex(int arg0) {
        }

        public void setType(int arg0) {
        }
    }

    static class ConjunctionToken
    implements Token {
        ConjunctionToken() {
        }

        public int getChannel() {
            return 0;
        }

        public int getCharPositionInLine() {
            return 0;
        }

        public CharStream getInputStream() {
            return null;
        }

        public int getLine() {
            return 0;
        }

        public String getText() {
            return null;
        }

        public int getTokenIndex() {
            return 0;
        }

        public int getType() {
            return 12;
        }

        public void setChannel(int arg0) {
        }

        public void setCharPositionInLine(int arg0) {
        }

        public void setInputStream(CharStream arg0) {
        }

        public void setLine(int arg0) {
        }

        public void setText(String arg0) {
        }

        public void setTokenIndex(int arg0) {
        }

        public void setType(int arg0) {
        }
    }

    static class PhraseToken
    implements Token {
        PhraseToken() {
        }

        public int getChannel() {
            return 0;
        }

        public int getCharPositionInLine() {
            return 0;
        }

        public CharStream getInputStream() {
            return null;
        }

        public int getLine() {
            return 0;
        }

        public String getText() {
            return null;
        }

        public int getTokenIndex() {
            return 0;
        }

        public int getType() {
            return 83;
        }

        public void setChannel(int arg0) {
        }

        public void setCharPositionInLine(int arg0) {
        }

        public void setInputStream(CharStream arg0) {
        }

        public void setLine(int arg0) {
        }

        public void setText(String arg0) {
        }

        public void setTokenIndex(int arg0) {
        }

        public void setType(int arg0) {
        }
    }

    static class WordToken
    implements Token {
        String text;

        WordToken(String text) {
            this.text = text;
        }

        public int getChannel() {
            return 0;
        }

        public int getCharPositionInLine() {
            return 0;
        }

        public CharStream getInputStream() {
            return null;
        }

        public int getLine() {
            return 0;
        }

        public String getText() {
            return this.text;
        }

        public int getTokenIndex() {
            return 0;
        }

        public int getType() {
            return 53;
        }

        public void setChannel(int arg0) {
        }

        public void setCharPositionInLine(int arg0) {
        }

        public void setInputStream(CharStream arg0) {
        }

        public void setLine(int arg0) {
        }

        public void setText(String arg0) {
        }

        public void setTokenIndex(int arg0) {
        }

        public void setType(int arg0) {
        }
    }
}

