/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.client;

import java.util.Properties;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.client.SOLRAPIClientFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SOLRAPIClientFactoryTest {
    @Mock
    private Properties props;
    @Mock
    private KeyResourceLoader keyResourceLoader;
    @Mock
    private DictionaryService dictionaryService;
    @Mock
    private NamespaceDAO namespaceDAO;
    private SOLRAPIClientFactory factory;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.props.getProperty((String)Mockito.eq((Object)"alfresco.host"), Mockito.anyString())).thenReturn((Object)"localhost");
        Mockito.when((Object)this.props.getProperty((String)Mockito.eq((Object)"alfresco.port"), Mockito.anyString())).thenReturn((Object)"8080");
        Mockito.when((Object)this.props.getProperty((String)Mockito.eq((Object)"alfresco.port.ssl"), Mockito.anyString())).thenReturn((Object)"8443");
        Mockito.when((Object)this.props.getProperty((String)Mockito.eq((Object)"alfresco.maxTotalConnections"), Mockito.anyString())).thenReturn((Object)"40");
        Mockito.when((Object)this.props.getProperty((String)Mockito.eq((Object)"alfresco.maxHostConnections"), Mockito.anyString())).thenReturn((Object)"40");
        Mockito.when((Object)this.props.getProperty((String)Mockito.eq((Object)"alfresco.socketTimeout"), Mockito.anyString())).thenReturn((Object)"0");
        Mockito.when((Object)this.props.getProperty((String)Mockito.eq((Object)"alfresco.secureComms"), Mockito.anyString())).thenReturn((Object)"none");
        this.factory = new SOLRAPIClientFactory();
    }

    @Test
    public void getsSameSOLRAPIClientForSameAlfresco() {
        SOLRAPIClient solrapiClient = this.factory.getSOLRAPIClient(this.props, this.keyResourceLoader, this.dictionaryService, this.namespaceDAO);
        Assert.assertNotNull((Object)solrapiClient);
        SOLRAPIClient solrapiClient2 = this.factory.getSOLRAPIClient(this.props, this.keyResourceLoader, this.dictionaryService, this.namespaceDAO);
        Assert.assertNotNull((Object)solrapiClient2);
        Assert.assertSame((Object)solrapiClient, (Object)solrapiClient2);
    }

    @Test
    public void getsDifferentSOLRAPIClientForDifferentAlfresco() {
        SOLRAPIClient solrapiClient = this.factory.getSOLRAPIClient(this.props, this.keyResourceLoader, this.dictionaryService, this.namespaceDAO);
        Assert.assertNotNull((Object)solrapiClient);
        Mockito.when((Object)this.props.getProperty("alfresco.port.ssl", "8443")).thenReturn((Object)"8444");
        SOLRAPIClient solrapiClient2 = this.factory.getSOLRAPIClient(this.props, this.keyResourceLoader, this.dictionaryService, this.namespaceDAO);
        Assert.assertNotNull((Object)solrapiClient2);
        Assert.assertNotSame((Object)solrapiClient, (Object)solrapiClient2);
    }
}

