/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.misc.transformers;

import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.util.CustomTransformerFileAdaptor;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AppleIWorksContentTransformer
implements CustomTransformerFileAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(AppleIWorksContentTransformer.class);
    private static final List<String> PDF_PATHS = ImmutableList.of((Object)"QuickLook/Preview.pdf");
    private static final List<String> JPG_PATHS = ImmutableList.of((Object)"QuickLook/Thumbnail.jpg", (Object)"preview.jpg");

    public String getTransformerName() {
        return "appleIWorks";
    }

    public void transform(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, File sourceFile, File targetFile, TransformManager transformManager) {
        logger.debug("Performing IWorks to jpeg transform with sourceMimetype={} targetMimetype={}", (Object)sourceMimetype, (Object)targetMimetype);
        try (ZipArchiveInputStream iWorksZip = new ZipArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(sourceFile)));){
            ZipArchiveEntry entry;
            List paths = "image/jpeg".equals(targetMimetype) ? JPG_PATHS : PDF_PATHS;
            boolean found = false;
            while ((entry = iWorksZip.getNextZipEntry()) != null) {
                String name = entry.getName();
                if (!paths.contains(name)) continue;
                Files.copy((InputStream)iWorksZip, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException("The source " + sourceMimetype + " file did not contain a " + targetMimetype + " preview");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to transform " + sourceMimetype + " file. It should have been a zip format file.", e);
        }
    }
}

