/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.Transformer;
import org.alfresco.transform.registry.AbstractTransformRegistry;
import org.alfresco.transform.registry.TransformCache;

public class FakeTransformRegistry
extends AbstractTransformRegistry {
    private static final String READ_FROM_A = "readFromA";
    private static final String BASE_URL_B = "baseUrlB";
    private final TransformCache data = new TransformCache();
    List<String> errorMessages = new ArrayList<String>();
    List<String> warnMessages = new ArrayList<String>();
    int registeredCount = 0;
    int readFromACount = 0;
    int baseUrlBCount = 0;
    Map<Transformer, String> transformerBaseUrls = new HashMap<Transformer, String>();

    protected void logError(String msg) {
        System.out.println(msg);
        this.errorMessages.add(msg);
    }

    protected void logWarn(String msg) {
        System.out.println(msg);
        this.warnMessages.add(msg);
    }

    public TransformCache getData() {
        return this.data;
    }

    protected void register(Transformer transformer, Map<String, Set<TransformOption>> transformOptions, String baseUrl, String readFrom) {
        super.register(transformer, transformOptions, baseUrl, readFrom);
        ++this.registeredCount;
        if (READ_FROM_A.equals(readFrom)) {
            ++this.readFromACount;
        }
        if (BASE_URL_B.equals(baseUrl)) {
            ++this.baseUrlBCount;
        }
        this.transformerBaseUrls.put(transformer, baseUrl);
    }
}

