/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.config.reader;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.transform.config.SupportedSourceAndTarget;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.TransformOptionGroup;
import org.alfresco.transform.config.TransformOptionValue;
import org.alfresco.transform.config.TransformStep;
import org.alfresco.transform.config.Transformer;
import org.alfresco.transform.config.reader.TransformConfigReader;
import org.alfresco.transform.config.reader.TransformConfigReaderFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class TransformConfigReaderJsonTest {
    @Test
    public void testEmptyRoutesFile() throws Exception {
        ClassPathResource resource = new ClassPathResource("config/sample1.json");
        TransformConfigReader loader = TransformConfigReaderFactory.create((Resource)resource);
        TransformConfig transformConfig = loader.load();
        List transformers = transformConfig.getTransformers();
        Assertions.assertNotNull((Object)transformers);
        Assertions.assertEquals(Collections.emptyList(), (Object)transformers);
    }

    @Test
    public void testMixedRoutesFile() throws Exception {
        List<Transformer> expected = this.prepareSample2();
        ClassPathResource resource = new ClassPathResource("config/sample2.json");
        TransformConfigReader loader = TransformConfigReaderFactory.create((Resource)resource);
        TransformConfig transformConfig = loader.load();
        List transformers = transformConfig.getTransformers();
        Assertions.assertNotNull((Object)transformers);
        Assertions.assertEquals((int)expected.size(), (int)transformers.size());
        Assertions.assertTrue((boolean)expected.containsAll(transformers));
    }

    private List<Transformer> prepareSample2() {
        return List.of(Transformer.builder().withTransformerName("CORE_AIO").withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("image/gif")).withTargetMediaType("image/gif")).build()))).withTransformOptions((Set)ImmutableSet.of((Object)"imageMagickOptions")).build(), Transformer.builder().withTransformerName("IMAGEMAGICK").withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("image/gif")).withTargetMediaType("image/gif")).build()))).withTransformOptions((Set)ImmutableSet.of((Object)"imageMagickOptions")).build(), Transformer.builder().withTransformerName("CORE_AIO").withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("application/msword")).withTargetMediaType("application/pdf")).withMaxSourceSizeBytes(Long.valueOf(0x1200000L)).build()))).build(), Transformer.builder().withTransformerName("PDF_RENDERER").withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("application/vnd.ms-powerpoint")).withTargetMediaType("application/pdf")).withPriority(Integer.valueOf(55)).withMaxSourceSizeBytes(Long.valueOf(0x3000000L)).build()))).build(), Transformer.builder().withTransformerName("CORE_AIO").withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/plain")).withTargetMediaType("text/plain")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/mediawiki")).withTargetMediaType("text/plain")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/css")).withTargetMediaType("text/plain")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/csv")).withTargetMediaType("text/plain")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/xml")).withTargetMediaType("text/plain")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/html")).withTargetMediaType("text/plain")).build()), (Object[])new SupportedSourceAndTarget[]{(SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("application/x-javascript")).withTargetMediaType("text/plain")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("application/dita+xml")).withTargetMediaType("text/plain")).build()})).withTransformOptions((Set)ImmutableSet.of((Object)"stringOptions")).build(), Transformer.builder().withTransformerName("officeToImageViaPdf").withTransformerPipeline((List)ImmutableList.of((Object)new TransformStep("libreoffice", "application/pdf"), (Object)new TransformStep("pdfToImageViaPng", null))).withTransformOptions((Set)ImmutableSet.of((Object)"pdfRendererOptions", (Object)"imageMagickOptions")).build(), Transformer.builder().withTransformerName("textToImageViaPdf").withTransformerPipeline((List)ImmutableList.of((Object)new TransformStep("libreoffice", "application/pdf"), (Object)new TransformStep("pdfToImageViaPng", null))).withTransformOptions((Set)ImmutableSet.of((Object)"pdfRendererOptions", (Object)"imageMagickOptions")).withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/plain")).withTargetMediaType("image/gif")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/plain")).withTargetMediaType("image/jpeg")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/plain")).withTargetMediaType("image/tiff")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/plain")).withTargetMediaType("image/png")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/csv")).withTargetMediaType("image/gif")).build()), (Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/csv")).withTargetMediaType("image/jpeg")).build()), (Object[])new SupportedSourceAndTarget[]{(SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/csv")).withTargetMediaType("image/tiff")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/csv")).withTargetMediaType("image/png")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/xml")).withTargetMediaType("image/gif")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/xml")).withTargetMediaType("image/jpeg")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/xml")).withTargetMediaType("image/tiff")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("text/xml")).withTargetMediaType("image/png")).build()})).withTransformOptions((Set)ImmutableSet.of((Object)"pdfRendererOptions", (Object)"imageMagickOptions")).build());
    }

    @Test
    public void testRouteFileWithTransformOptions() throws Exception {
        List<Transformer> expected = this.prepareSample5Transformers();
        Map<String, Set<TransformOption>> expectedOptions = TransformConfigReaderJsonTest.prepareSample5Options();
        ClassPathResource resource = new ClassPathResource("config/sample5.json");
        TransformConfigReader loader = TransformConfigReaderFactory.create((Resource)resource);
        TransformConfig transformConfig = loader.load();
        List transformers = transformConfig.getTransformers();
        Map transformOptions = transformConfig.getTransformOptions();
        Assertions.assertNotNull((Object)transformers);
        Assertions.assertEquals((int)expected.size(), (int)transformers.size());
        Assertions.assertTrue((boolean)expected.containsAll(transformers));
        Assertions.assertEquals(expectedOptions, (Object)transformOptions);
    }

    private List<Transformer> prepareSample5Transformers() {
        return List.of(Transformer.builder().withTransformerName("CORE_AIO").withSupportedSourceAndTargetList((Set)ImmutableSet.of((Object)((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("image/gif")).withTargetMediaType("image/gif")).build()))).withTransformOptions((Set)ImmutableSet.of((Object)"imageMagickOptions")).build());
    }

    public static Map<String, Set<TransformOption>> prepareSample5Options() {
        return ImmutableMap.of((Object)"imageMagickOptions", (Object)ImmutableSet.of((Object)new TransformOptionValue(false, "alphaRemove"), (Object)new TransformOptionValue(false, "autoOrient"), (Object)new TransformOptionValue(false, "startPage"), (Object)new TransformOptionValue(false, "endPage"), (Object)new TransformOptionGroup(false, (Set)ImmutableSet.of((Object)new TransformOptionValue(false, "cropGravity"), (Object)new TransformOptionValue(false, "cropWidth"), (Object)new TransformOptionValue(false, "cropHeight"), (Object)new TransformOptionValue(false, "cropPercentage"), (Object)new TransformOptionValue(false, "cropXOffset"), (Object)new TransformOptionValue(false, "cropYOffset"), (Object[])new TransformOption[0])), (Object)new TransformOptionGroup(false, (Set)ImmutableSet.of((Object)new TransformOptionValue(false, "thumbnail"), (Object)new TransformOptionValue(false, "resizeHeight"), (Object)new TransformOptionValue(false, "resizeWidth"), (Object)new TransformOptionValue(false, "resizePercentage"), (Object)new TransformOptionValue(false, "allowEnlargement"), (Object)new TransformOptionValue(false, "maintainAspectRatio"), (Object[])new TransformOption[0])), (Object[])new TransformOption[0]));
    }
}

