/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.config.reader;

import java.util.Objects;
import org.alfresco.transform.config.reader.TransformConfigReader;
import org.alfresco.transform.config.reader.TransformConfigReaderJson;
import org.alfresco.transform.config.reader.TransformConfigReaderYaml;
import org.springframework.core.io.Resource;

public class TransformConfigReaderFactory {
    private TransformConfigReaderFactory() {
    }

    public static TransformConfigReader create(Resource resource) {
        String extension;
        String fileName = resource.getFilename();
        if (Objects.isNull(fileName) || !fileName.contains(".")) {
            throw new RuntimeException("Invalid configuration file: " + fileName);
        }
        switch (extension = fileName.substring(fileName.lastIndexOf(46) + 1)) {
            case "properties": {
                throw new UnsupportedOperationException(".properties configuration files are no longer supported: " + fileName);
            }
            case "yaml": 
            case "yml": {
                return new TransformConfigReaderYaml(resource);
            }
            case "json": {
                return new TransformConfigReaderJson(resource);
            }
        }
        throw new RuntimeException("Unknown configuration file type: " + fileName);
    }
}

