/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.registry;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.transform.config.SupportedSourceAndTarget;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.TransformStep;
import org.alfresco.transform.config.Transformer;
import org.alfresco.transform.registry.AbstractTransformRegistry;
import org.alfresco.transform.registry.CombinedTransformConfig;
import org.alfresco.transform.registry.FakeTransformRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CombinedTransformConfigTest {
    private static final Transformer TRANSFORMER1_A2B_A2E = Transformer.builder().withTransformerName("1").withSupportedSourceAndTargetList(Set.of((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/b")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/e")).build())).build();
    private static final Transformer TRANSFORMER1_A2B = Transformer.builder().withTransformerName("1").withSupportedSourceAndTargetList(Set.of((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/b")).build())).build();
    private static final Transformer TRANSFORMER1_A2E = Transformer.builder().withTransformerName("1").withSupportedSourceAndTargetList(Set.of((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/e")).build())).build();
    private static final Transformer TRANSFORMER1_A2D = Transformer.builder().withTransformerName("1").withSupportedSourceAndTargetList(Set.of((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/d")).build())).build();
    private final Transformer PIPELINE1_2C3 = Transformer.builder().withTransformerName("1").withTransformerPipeline(List.of(new TransformStep("2", "mimetype/c"), new TransformStep("3", null))).build();
    private final Transformer PIPELINE1_2C3_COPY = Transformer.builder().withTransformerName("1").withTransformerPipeline(List.of(new TransformStep("2", "mimetype/c"), new TransformStep("3", null))).build();
    private static final Transformer TRANSFORMER2_B2C = Transformer.builder().withTransformerName("2").withSupportedSourceAndTargetList(Set.of((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/b")).withTargetMediaType("mimetype/c")).build())).build();
    private static final Transformer TRANSFORMER2_A2C = Transformer.builder().withTransformerName("2").withSupportedSourceAndTargetList(Set.of((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/c")).build())).build();
    private static final Transformer TRANSFORMER2_B2X = Transformer.builder().withTransformerName("2").withSupportedSourceAndTargetList(Set.of((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/b")).withTargetMediaType("mimetype/X")).build())).build();
    private static final Transformer TRANSFORMER3_C2D = Transformer.builder().withTransformerName("3").withSupportedSourceAndTargetList(Set.of((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/c")).withTargetMediaType("mimetype/d")).build())).build();
    private static final Transformer TRANSFORMER3_C2D_C2E = Transformer.builder().withTransformerName("3").withSupportedSourceAndTargetList(Set.of((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/c")).withTargetMediaType("mimetype/d")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/e")).build())).build();
    private static final Transformer TRANSFORMER1 = Transformer.builder().withTransformerName("1").build();
    private static final Transformer TRANSFORMER2 = Transformer.builder().withTransformerName("2").build();
    private static final Transformer TRANSFORMER3 = Transformer.builder().withTransformerName("3").build();
    public static final Transformer TRANSFORMER_WITH_NO_NAME = Transformer.builder().withTransformerName("").build();
    public static final String PASS_THROUGH_NAME = "PassThrough";
    private static final Transformer PASS_THROUGH = Transformer.builder().withTransformerName("PassThrough").build();
    private static final Transformer PASS_THROUGH_COPY = Transformer.builder().withTransformerName("PassThrough").build();
    private final Transformer PIPELINE4_1B2C3 = Transformer.builder().withTransformerName("4").withTransformerPipeline(List.of(new TransformStep("1", "mimetype/b"), new TransformStep("2", "mimetype/c"), new TransformStep("3", null))).build();
    private final Transformer FAILOVER1_23 = Transformer.builder().withTransformerName("1").withTransformerFailover(List.of("2", "3")).build();
    private final Transformer FAILOVER4_123 = Transformer.builder().withTransformerName("4").withTransformerFailover(List.of("1", "2", "3")).build();
    private final TransformConfig ONE_TRANSFORM = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)this.PIPELINE1_2C3)).build();
    private static final TransformConfig TWO_TRANSFORMS = TransformConfig.builder().withTransformOptions((Map)ImmutableMap.of((Object)"options/1", Collections.emptySet(), (Object)"options/2", Collections.emptySet())).withTransformers((List)ImmutableList.of((Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D)).build();
    private static final String READ_FROM_A = "readFromA";
    private static final String READ_FROM_B = "readFromB";
    private static final String ROUTER_CONFIG_HAS_NO_BASE_URL = null;
    private static final String BASE_URL_B = "baseUrlB";
    private final CombinedTransformConfig config = new CombinedTransformConfig(){

        protected boolean isPassThroughTransformName(String name) {
            return CombinedTransformConfigTest.PASS_THROUGH_NAME.equals(name);
        }
    };
    private final FakeTransformRegistry registry = new FakeTransformRegistry();
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private TransformConfig readTransformConfigFromResource(String filename) throws IOException {
        return (TransformConfig)objectMapper.readValue(this.getClass().getClassLoader().getResourceAsStream(filename), TransformConfig.class);
    }

    private String expectedWildcardError(String errorReason) {
        return "No supported source and target mimetypes could be added to the transformer \"4\" as " + errorReason + ". Read from readFromB";
    }

    private void assertOverride(List<Transformer> tEngineTransformers, List<Transformer> tRouterTransformers, String expectedError) {
        Transformer expectedTransformer = tRouterTransformers.isEmpty() ? tEngineTransformers.get(tEngineTransformers.size() - 1) : tRouterTransformers.get(tRouterTransformers.size() - 1);
        TransformConfig tEngineTransformConfig = TransformConfig.builder().withTransformers(tEngineTransformers).build();
        TransformConfig tRouterTransformConfig = TransformConfig.builder().withTransformers(tRouterTransformers).build();
        this.config.addTransformConfig(tEngineTransformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.addTransformConfig(tRouterTransformConfig, READ_FROM_A, ROUTER_CONFIG_HAS_NO_BASE_URL, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        this.config.registerCombinedTransformers((AbstractTransformRegistry)this.registry);
        TransformConfig transformConfig = this.config.buildTransformConfig();
        if (expectedError == null) {
            boolean isFailover;
            Assertions.assertEquals((int)0, (int)this.registry.errorMessages.size());
            int numberOfTEngineTransformers = tEngineTransformers.size();
            Assertions.assertEquals((int)numberOfTEngineTransformers, (int)this.config.buildTransformConfig().getTransformers().size());
            Assertions.assertEquals((int)numberOfTEngineTransformers, (int)transformConfig.getTransformers().size());
            Transformer actualTransformer = (Transformer)transformConfig.getTransformers().get(numberOfTEngineTransformers - 1);
            Assertions.assertEquals((Object)expectedTransformer, (Object)actualTransformer);
            Assertions.assertSame((Object)expectedTransformer, (Object)actualTransformer);
            List pipeline = actualTransformer.getTransformerPipeline();
            List failover = actualTransformer.getTransformerFailover();
            boolean isPipeline = pipeline != null && !pipeline.isEmpty();
            boolean bl = isFailover = failover != null && !failover.isEmpty();
            if (!isPipeline && !isFailover) {
                Assertions.assertEquals((Object)BASE_URL_B, (Object)this.registry.transformerBaseUrls.get(actualTransformer));
            }
            Assertions.assertEquals((Object)"1", (Object)this.registry.findTransformerName("mimetype/a", -1L, "mimetype/d", Collections.emptyMap(), null));
            Assertions.assertNull((Object)this.registry.findTransformerName("mimetype/a", -1L, "mimetype/b", Collections.emptyMap(), null));
        } else {
            Assertions.assertEquals((int)1, (int)this.registry.errorMessages.size());
            Assertions.assertEquals((Object)expectedError, (Object)this.registry.errorMessages.get(0));
        }
    }

    @Test
    public void testClear() {
        this.config.addTransformConfig(TWO_TRANSFORMS, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)2, (int)this.config.buildTransformConfig().getTransformers().size());
        Assertions.assertEquals((int)2, (int)this.config.buildTransformConfig().getTransformOptions().size());
        this.config.clear();
        Assertions.assertEquals((int)0, (int)this.config.buildTransformConfig().getTransformers().size());
        Assertions.assertEquals((int)0, (int)this.config.buildTransformConfig().getTransformOptions().size());
    }

    @Test
    public void testCombineTransformerConfigNoOp() {
        this.config.addTransformConfig(TWO_TRANSFORMS, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.addTransformConfig(this.ONE_TRANSFORM, READ_FROM_A, ROUTER_CONFIG_HAS_NO_BASE_URL, (AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)3, (int)this.config.buildTransformConfig().getTransformers().size());
        Assertions.assertEquals((int)2, (int)this.config.buildTransformConfig().getTransformOptions().size());
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)3, (int)this.config.buildTransformConfig().getTransformers().size());
        Assertions.assertEquals((int)2, (int)this.config.buildTransformConfig().getTransformOptions().size());
    }

    @Test
    public void testTransformersAreRegistered() {
        this.config.addTransformConfig(TWO_TRANSFORMS, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.addTransformConfig(this.ONE_TRANSFORM, READ_FROM_A, ROUTER_CONFIG_HAS_NO_BASE_URL, (AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)3, (int)this.config.buildTransformConfig().getTransformers().size());
        Assertions.assertEquals((int)2, (int)this.config.buildTransformConfig().getTransformOptions().size());
        this.config.registerCombinedTransformers((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)3, (int)this.registry.registeredCount);
        Assertions.assertEquals((int)1, (int)this.registry.readFromACount);
        Assertions.assertEquals((int)2, (int)this.registry.baseUrlBCount);
    }

    @Test
    public void testInvalidBothPipelineAndFailover() {
        Transformer invalidTransformer = Transformer.builder().withTransformerName("2").withTransformerPipeline(List.of(new TransformStep("1", "mimetype/b"), new TransformStep("2", "mimetype/c"), new TransformStep("3", null))).withTransformerFailover(List.of("1", "2", "3")).build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1_A2B_A2E, (Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D, (Object)invalidTransformer)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        String expected = "Transformer \"2\" cannot have both pipeline and failover sections. Read from readFromB";
        Assertions.assertEquals((int)1, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.errorMessages.get(0));
    }

    @Test
    public void testInvalidNoName() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER_WITH_NO_NAME)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        String expected = "Transformer names may not be null. Read from readFromB";
        Assertions.assertEquals((int)1, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.errorMessages.get(0));
    }

    @Test
    public void testInvalidTransformOptionsUnknown() {
        Transformer transformer = Transformer.builder().withTransformerName("1").withTransformOptions((Set)ImmutableSet.of((Object)"unknown")).build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)transformer)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        String expected = "Transformer \"1\" references \"unknown\" which do not exist. Read from readFromB";
        Assertions.assertEquals((int)1, (int)this.registry.warnMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.warnMessages.get(0));
    }

    @Test
    public void testInvalidDuplicateTEngineSingleStepTransform() {
        Transformer transformer = Transformer.builder().withTransformerName("1").build();
        Transformer identicalTransformer = Transformer.builder().withTransformerName("1").build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)transformer, (Object)identicalTransformer)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        String expected = "Transformer \"1\" must be a unique name. Read from readFromB";
        Assertions.assertEquals((int)1, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.errorMessages.get(0));
    }

    @Test
    public void testOverrideSingleStepWithSingleStepInTEngine() {
        Transformer transformerWithSameNameButDifferentDefinition = Transformer.builder().withTransformerName("1").withTransformOptions((Set)ImmutableSet.of((Object)"options/1")).build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1, (Object)transformerWithSameNameButDifferentDefinition)).withTransformOptions((Map)ImmutableMap.of((Object)"options/1", Collections.emptySet())).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        String expected = "Transformer \"1\" must be a unique name. Read from readFromB";
        Assertions.assertEquals((int)1, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.errorMessages.get(0));
    }

    @Test
    public void testInvalidSingleStepTransformInRouter() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_A, ROUTER_CONFIG_HAS_NO_BASE_URL, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        String expected = "Single step transformers (such as \"1\") must be defined in a T-Engine rather than in a pipeline file, unless they are overriding an existing single step definition. Read from readFromA";
        Assertions.assertEquals((int)1, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.errorMessages.get(0));
    }

    @Test
    public void testOverrideSingleStepWithSingleStepInTRouter() {
        this.assertOverride((List<Transformer>)ImmutableList.of((Object)TRANSFORMER1_A2B_A2E), (List<Transformer>)ImmutableList.of((Object)TRANSFORMER1_A2D), null);
    }

    @Test
    public void testOverrideMultipleTimesSingleStepWithSingleStepInTRouter() {
        this.assertOverride((List<Transformer>)ImmutableList.of((Object)TRANSFORMER1_A2B_A2E), (List<Transformer>)ImmutableList.of((Object)TRANSFORMER1_A2B, (Object)TRANSFORMER1_A2E, (Object)TRANSFORMER1_A2D), null);
    }

    @Test
    public void testOverrideSingleStepWithPipelineInTRouter() {
        this.assertOverride((List<Transformer>)ImmutableList.of((Object)TRANSFORMER1_A2B_A2E, (Object)TRANSFORMER2_A2C, (Object)TRANSFORMER3_C2D), (List<Transformer>)ImmutableList.of((Object)this.PIPELINE1_2C3), null);
    }

    @Test
    public void testOverridePipelineWithPipelineInTRouter() {
        this.assertOverride((List<Transformer>)ImmutableList.of((Object)this.PIPELINE1_2C3, (Object)TRANSFORMER2_A2C, (Object)TRANSFORMER3_C2D), (List<Transformer>)ImmutableList.of((Object)this.PIPELINE1_2C3_COPY), null);
    }

    @Test
    public void testInvalidOverridePipelineWithSingleStepInTRouter() {
        this.assertOverride((List<Transformer>)ImmutableList.of((Object)this.PIPELINE1_2C3, (Object)TRANSFORMER2_A2C, (Object)TRANSFORMER3_C2D), (List<Transformer>)ImmutableList.of((Object)TRANSFORMER1_A2D), "Single step transformers (such as \"1\") may not override a pipeline or failover transform as there is no T-Engine to perform work. Read from readFromA");
    }

    @Test
    public void testInvalidOverrideFailoverWithSingleStepInTRouter() {
        this.assertOverride((List<Transformer>)ImmutableList.of((Object)this.FAILOVER1_23, (Object)TRANSFORMER2_A2C, (Object)TRANSFORMER3_C2D), (List<Transformer>)ImmutableList.of((Object)TRANSFORMER1_A2D), "Single step transformers (such as \"1\") may not override a pipeline or failover transform as there is no T-Engine to perform work. Read from readFromA");
    }

    @Test
    public void testSinglePassThroughInTRouter() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)PASS_THROUGH)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_A, ROUTER_CONFIG_HAS_NO_BASE_URL, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)0, (int)this.registry.errorMessages.size());
    }

    @Test
    public void testMultiplePassThroughInTRouter() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)PASS_THROUGH, (Object)PASS_THROUGH_COPY)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_A, ROUTER_CONFIG_HAS_NO_BASE_URL, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        String expected = "Pipeline files should not use \"PassThrough\" as a transform name. Read from readFromA";
        Assertions.assertEquals((int)1, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.errorMessages.get(0));
    }

    @Test
    public void testPassThroughInTEngine() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)PASS_THROUGH)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        String expected = "T-Engines should not use \"PassThrough\" as a transform name. Read from readFromB";
        Assertions.assertEquals((int)1, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.errorMessages.get(0));
    }

    @Test
    public void testInvalidOverrideSingleStepWithPipelineInTEngine() {
        this.assertOverride((List<Transformer>)ImmutableList.of((Object)TRANSFORMER1_A2B_A2E, (Object)TRANSFORMER2_A2C, (Object)TRANSFORMER3_C2D, (Object)this.PIPELINE1_2C3), Collections.emptyList(), "Transformer \"1\" must be a unique name. Read from readFromB");
    }

    @Test
    public void testInvalidOverridePipelineWithSingleStepInTEngine() {
        this.assertOverride((List<Transformer>)ImmutableList.of((Object)TRANSFORMER2_A2C, (Object)TRANSFORMER3_C2D, (Object)this.PIPELINE1_2C3, (Object)TRANSFORMER1_A2B_A2E), Collections.emptyList(), "Transformer \"1\" must be a unique name. Read from readFromB");
    }

    @Test
    public void testInvalidIndexToRemoveBeforeCurrent() {
        TransformConfig tEngineTransformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1_A2B_A2E, (Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D)).build();
        TransformConfig tRouterTransformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1_A2D)).build();
        this.config.addTransformConfig(tEngineTransformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.addTransformConfig(tRouterTransformConfig, READ_FROM_A, ROUTER_CONFIG_HAS_NO_BASE_URL, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)3, (int)this.config.buildTransformConfig().getTransformers().size());
    }

    @Test
    public void testInvalidIndexToRemoveIsCurrent() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1_A2D, (Object)TRANSFORMER2_B2C, (Object)TRANSFORMER_WITH_NO_NAME, (Object)TRANSFORMER3_C2D)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)3, (int)this.config.buildTransformConfig().getTransformers().size());
    }

    @Test
    public void testSortSoNoForwardRefs() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)this.PIPELINE1_2C3, (Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        List transformers = this.config.buildTransformConfig().getTransformers();
        Assertions.assertEquals((int)3, (int)transformers.size());
        Assertions.assertEquals((Object)"1", (Object)((Transformer)transformers.get(0)).getTransformerName());
        Assertions.assertEquals((Object)"2", (Object)((Transformer)transformers.get(1)).getTransformerName());
        Assertions.assertEquals((Object)"3", (Object)((Transformer)transformers.get(2)).getTransformerName());
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        transformers = this.config.buildTransformConfig().getTransformers();
        Assertions.assertEquals((int)3, (int)transformers.size());
        Assertions.assertEquals((Object)"2", (Object)((Transformer)transformers.get(0)).getTransformerName());
        Assertions.assertEquals((Object)"3", (Object)((Transformer)transformers.get(1)).getTransformerName());
        Assertions.assertEquals((Object)"1", (Object)((Transformer)transformers.get(2)).getTransformerName());
        Assertions.assertEquals((int)0, (int)this.registry.warnMessages.size());
        Assertions.assertEquals((int)0, (int)this.registry.errorMessages.size());
    }

    @Test
    public void testInvalidTransformStepNullIntermediateMimetype() {
        Transformer pipeline = Transformer.builder().withTransformerName("5").withTransformerPipeline(List.of(new TransformStep("1", "mimetype/b"), new TransformStep("2", null), new TransformStep("3", null))).build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1_A2B, (Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D, (Object)pipeline)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)2, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)"No supported source and target mimetypes could be added to the transformer \"5\" as intermediate steps should have a target mimetype. Read from readFromB", (Object)this.registry.errorMessages.get(0));
        Assertions.assertEquals((Object)"Transformer \"5\" has no supported source and target mimetypes, so will be ignored. Read from readFromB", (Object)this.registry.errorMessages.get(1));
    }

    @Test
    public void testInvalidTransformStepNonNullFinalMimetype() {
        Transformer pipeline = Transformer.builder().withTransformerName("5").withTransformerPipeline(List.of(new TransformStep("1", "mimetype/b"), new TransformStep("2", "mimetype/c"), new TransformStep("3", "mimetype/d"))).build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1_A2B, (Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D, (Object)pipeline)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)2, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)"No supported source and target mimetypes could be added to the transformer \"5\" as the final step should not have a target mimetype. Read from readFromB", (Object)this.registry.errorMessages.get(0));
        Assertions.assertEquals((Object)"Transformer \"5\" has no supported source and target mimetypes, so will be ignored. Read from readFromB", (Object)this.registry.errorMessages.get(1));
    }

    @Test
    public void testIgnorePipelineWithMissingStep() {
        Transformer pipeline = Transformer.builder().withTransformerName("1").withTransformerPipeline(List.of(new TransformStep("2", "mimetype/c"), new TransformStep("3", "mimetype/d"), new TransformStep("4", null))).build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D, (Object)pipeline)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        String expected = "Transformer \"1\" ignored as step transforms (\"4\") do not exist. Read from readFromB";
        Assertions.assertEquals((int)1, (int)this.registry.warnMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.warnMessages.get(0));
    }

    @Test
    public void testIgnorePipelineWithMissingSteps() {
        Transformer pipeline = Transformer.builder().withTransformerName("1").withTransformerPipeline(List.of(new TransformStep("3", "mimetype/d"), new TransformStep("4", "mimetype/e"), new TransformStep("5", "mimetype/f"), new TransformStep("2", "mimetype/c"), new TransformStep("6", null))).build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D, (Object)pipeline)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        String expected = "Transformer \"1\" ignored as step transforms (\"4\", \"5\", \"6\") do not exist. Read from readFromB";
        Assertions.assertEquals((int)1, (int)this.registry.warnMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.warnMessages.get(0));
    }

    @Test
    public void testPipelineWithValidSupportedSourceAndTarget() {
        Transformer pipeline = Transformer.builder().withTransformerName("1").withTransformerPipeline(List.of(new TransformStep("2", "mimetype/c"), new TransformStep("3", null))).withSupportedSourceAndTargetList(Set.of((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/d")).build())).build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER2_A2C, (Object)TRANSFORMER3_C2D, (Object)pipeline)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        this.config.registerCombinedTransformers((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)0, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((int)3, (int)this.config.buildTransformConfig().getTransformers().size());
        Assertions.assertEquals((Object)"1", (Object)this.registry.findTransformerName("mimetype/a", -1L, "mimetype/d", Collections.emptyMap(), null));
        Assertions.assertEquals((Object)"2", (Object)this.registry.findTransformerName("mimetype/a", -1L, "mimetype/c", Collections.emptyMap(), null));
        Assertions.assertEquals((Object)"3", (Object)this.registry.findTransformerName("mimetype/c", -1L, "mimetype/d", Collections.emptyMap(), null));
    }

    @Test
    public void testPipelineWithValidWildcardSupportedSourceAndTarget() {
        Transformer pipeline = Transformer.builder().withTransformerName("1").withTransformerPipeline(List.of(new TransformStep("2", "mimetype/c"), new TransformStep("3", null))).build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER2_A2C, (Object)TRANSFORMER3_C2D, (Object)pipeline)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        this.config.registerCombinedTransformers((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)0, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((int)3, (int)this.config.buildTransformConfig().getTransformers().size());
        Assertions.assertEquals((Object)"1", (Object)this.registry.findTransformerName("mimetype/a", -1L, "mimetype/d", Collections.emptyMap(), null));
    }

    @Test
    public void testIgnorePipelineWithInvalidSupportedSourceAndTarget() {
        Transformer pipeline = Transformer.builder().withTransformerName("1").withTransformerPipeline(List.of(new TransformStep("2", "mimetype/c"), new TransformStep("2", null))).withSupportedSourceAndTargetList(Set.of((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/d")).build())).build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D, (Object)pipeline)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        this.config.registerCombinedTransformers((AbstractTransformRegistry)this.registry);
        String expected = "Pipeline transformer \"1\" steps do not support (mimetype/a->mimetype/d) so will be ignored";
        Assertions.assertEquals((int)1, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.errorMessages.get(0));
        Assertions.assertEquals((int)2, (int)this.config.buildTransformConfig().getTransformers().size());
        Assertions.assertEquals((Object)"2", (Object)this.registry.findTransformerName("mimetype/b", -1L, "mimetype/c", Collections.emptyMap(), null));
        Assertions.assertEquals((Object)"3", (Object)this.registry.findTransformerName("mimetype/c", -1L, "mimetype/d", Collections.emptyMap(), null));
    }

    @Test
    public void testIgnorePipelineWithMultipleInvalidSupportedSourceAndTarget() {
        Transformer pipeline = Transformer.builder().withTransformerName("1").withTransformerPipeline(List.of(new TransformStep("2", "mimetype/c"), new TransformStep("2", null))).withSupportedSourceAndTargetList(Set.of((SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/a")).withTargetMediaType("mimetype/d")).build(), (SupportedSourceAndTarget)((SupportedSourceAndTarget.Builder)((SupportedSourceAndTarget.Builder)SupportedSourceAndTarget.builder().withSourceMediaType("mimetype/x")).withTargetMediaType("mimetype/y")).build())).build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D, (Object)pipeline)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        this.config.registerCombinedTransformers((AbstractTransformRegistry)this.registry);
        String expected = "Pipeline transformer \"1\" steps do not support (mimetype/a->mimetype/d, mimetype/x->mimetype/y) so will be ignored";
        Assertions.assertEquals((int)1, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)expected, (Object)this.registry.errorMessages.get(0));
    }

    @Test
    public void testIgnorePipelineWithInvalidWildcardSupportedSourceAndTarget() {
        Transformer pipeline = Transformer.builder().withTransformerName("1").withTransformerPipeline(List.of(new TransformStep("2", "mimetype/c"), new TransformStep("2", null))).build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER2_B2X, (Object)TRANSFORMER3_C2D, (Object)pipeline)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        this.config.registerCombinedTransformers((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)2, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)"No supported source and target mimetypes could be added to the transformer \"1\" as the first step transformer \"2\" does not support to \"mimetype/c\". Read from readFromB", (Object)this.registry.errorMessages.get(0));
        Assertions.assertEquals((Object)"Transformer \"1\" has no supported source and target mimetypes, so will be ignored. Read from readFromB", (Object)this.registry.errorMessages.get(1));
        Assertions.assertEquals((int)2, (int)this.config.buildTransformConfig().getTransformers().size());
    }

    @Test
    public void testInvalidCircularTransformStep() {
        Transformer pipeline1 = Transformer.builder().withTransformerName("1").withTransformerPipeline(List.of(new TransformStep("2", "mimetype/c"), new TransformStep("4", null))).build();
        Transformer pipeline4 = Transformer.builder().withTransformerName("4").withTransformerPipeline(List.of(new TransformStep("3", "mimetype/d"), new TransformStep("5", "mimetype/f"), new TransformStep("1", null))).build();
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D, (Object)pipeline1, (Object)pipeline4)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)2, (int)this.registry.warnMessages.size());
        Assertions.assertEquals((Object)"Transformer \"1\" ignored as step transforms (\"4\") do not exist. Read from readFromB", (Object)this.registry.warnMessages.get(0));
        Assertions.assertEquals((Object)"Transformer \"4\" ignored as step transforms (\"1\", \"5\") do not exist. Read from readFromB", (Object)this.registry.warnMessages.get(1));
    }

    @Test
    public void testWildcardNoOp() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1_A2B_A2E, (Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        this.config.registerCombinedTransformers((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)0, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((int)3, (int)this.config.buildTransformConfig().getTransformers().size());
        Assertions.assertEquals((Object)"1", (Object)this.registry.findTransformerName("mimetype/a", -1L, "mimetype/b", Collections.emptyMap(), null));
        Assertions.assertEquals((Object)"2", (Object)this.registry.findTransformerName("mimetype/b", -1L, "mimetype/c", Collections.emptyMap(), null));
        Assertions.assertEquals((Object)"3", (Object)this.registry.findTransformerName("mimetype/c", -1L, "mimetype/d", Collections.emptyMap(), null));
    }

    @Test
    public void testWildcardPipeline() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1_A2B_A2E, (Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D, (Object)this.PIPELINE4_1B2C3)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        this.config.registerCombinedTransformers((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)0, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((int)4, (int)this.config.buildTransformConfig().getTransformers().size());
        Assertions.assertEquals((Object)"4", (Object)this.registry.findTransformerName("mimetype/a", -1L, "mimetype/d", Collections.emptyMap(), null));
        Assertions.assertEquals((Object)"1", (Object)this.registry.findTransformerName("mimetype/a", -1L, "mimetype/b", Collections.emptyMap(), null));
    }

    @Test
    public void testWildcardPipelineExcludeFirstTransformsSupportedFromCartesianProduct() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1_A2B_A2E, (Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D_C2E, (Object)this.PIPELINE4_1B2C3)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        this.config.registerCombinedTransformers((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)0, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((int)4, (int)this.config.buildTransformConfig().getTransformers().size());
        Assertions.assertEquals((Object)"4", (Object)this.registry.findTransformerName("mimetype/a", -1L, "mimetype/d", Collections.emptyMap(), null));
        Assertions.assertEquals((Object)"1", (Object)this.registry.findTransformerName("mimetype/a", -1L, "mimetype/e", Collections.emptyMap(), null));
    }

    @Test
    public void testPipelineUnsupportedIntermediate() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1_A2B_A2E, (Object)TRANSFORMER2_B2X, (Object)TRANSFORMER3_C2D, (Object)this.PIPELINE4_1B2C3)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)2, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)this.expectedWildcardError("the step transformer \"2\" does not support \"mimetype/b\" to \"mimetype/c\""), (Object)this.registry.errorMessages.get(0));
        Assertions.assertEquals((Object)"Transformer \"4\" has no supported source and target mimetypes, so will be ignored. Read from readFromB", (Object)this.registry.errorMessages.get(1));
        Assertions.assertEquals((int)3, (int)this.config.buildTransformConfig().getTransformers().size());
    }

    @Test
    public void testWildcardFailover() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1_A2B_A2E, (Object)TRANSFORMER2_B2C, (Object)TRANSFORMER3_C2D, (Object)this.FAILOVER4_123)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        this.config.registerCombinedTransformers((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((int)0, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((int)4, (int)this.config.buildTransformConfig().getTransformers().size());
        Assertions.assertEquals((Object)"4", (Object)this.registry.findTransformerName("mimetype/a", -1L, "mimetype/b", Collections.emptyMap(), null));
    }

    @Test
    public void testWildcardFailoverNoneSupported() {
        TransformConfig transformConfig = TransformConfig.builder().withTransformers((List)ImmutableList.of((Object)TRANSFORMER1, (Object)TRANSFORMER2, (Object)TRANSFORMER3, (Object)this.FAILOVER4_123)).build();
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        Assertions.assertEquals((Object)this.expectedWildcardError("the step transforms don't support any"), (Object)this.registry.errorMessages.get(0));
    }

    @Test
    public void testJsonComplete() throws Exception {
        TransformConfig transformConfig = this.readTransformConfigFromResource("engine_config_complete.json");
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        TransformConfig combinedTransformConfig = this.config.buildTransformConfig();
        Assertions.assertEquals((int)0, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((int)1, (int)combinedTransformConfig.getTransformers().size());
        Assertions.assertEquals((int)1, (int)combinedTransformConfig.getTransformOptions().size());
    }

    @Test
    public void testJsonDuplicateOptionsAndSupportedMimetypes() throws Exception {
        TransformConfig transformConfig = this.readTransformConfigFromResource("engine_config_with_duplicates.json");
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        TransformConfig combinedTransformConfig = this.config.buildTransformConfig();
        Assertions.assertEquals((int)0, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((int)1, (int)combinedTransformConfig.getTransformers().size());
        Assertions.assertEquals((int)1, (int)combinedTransformConfig.getTransformOptions().size());
    }

    @Test
    public void testJsonNoOptions() throws Exception {
        TransformConfig transformConfig = this.readTransformConfigFromResource("engine_config_no_transform_options.json");
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        TransformConfig combinedTransformConfig = this.config.buildTransformConfig();
        Assertions.assertEquals((int)0, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((int)1, (int)combinedTransformConfig.getTransformers().size());
        Assertions.assertEquals((int)0, (int)combinedTransformConfig.getTransformOptions().size());
    }

    @Test
    public void testJsonIncompleteNoTransformName() throws Exception {
        TransformConfig transformConfig = this.readTransformConfigFromResource("engine_config_incomplete.json");
        this.config.addTransformConfig(transformConfig, READ_FROM_B, BASE_URL_B, (AbstractTransformRegistry)this.registry);
        this.config.combineTransformerConfig((AbstractTransformRegistry)this.registry);
        TransformConfig combinedTransformConfig = this.config.buildTransformConfig();
        Assertions.assertEquals((int)1, (int)this.registry.errorMessages.size());
        Assertions.assertEquals((Object)"Transformer names may not be null. Read from readFromB", (Object)this.registry.errorMessages.get(0));
        Assertions.assertEquals((int)0, (int)combinedTransformConfig.getTransformers().size());
    }
}

