/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika.metadata.extractors;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.transform.tika.metadata.extractors.TikaAudioMetadataExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.mp3.Mp3Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MP3MetadataExtractor
extends TikaAudioMetadataExtractor {
    private static final Logger logger = LoggerFactory.getLogger(MP3MetadataExtractor.class);
    private static final String KEY_SONG_TITLE = "songTitle";
    private static final String KEY_ALBUM_TITLE = "albumTitle";
    private static final String KEY_ARTIST = "artist";
    private static final String KEY_COMMENT = "comment";
    private static final String KEY_YEAR_RELEASED = "yearReleased";
    private static final String KEY_TRACK_NUMBER = "trackNumber";
    private static final String KEY_GENRE = "genre";
    private static final String KEY_COMPOSER = "composer";

    public MP3MetadataExtractor() {
        super(logger);
    }

    protected Parser getParser() {
        return new Mp3Parser();
    }

    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        super.extractSpecific(metadata, properties, headers);
        this.putRawValue(KEY_ALBUM_TITLE, (Serializable)((Object)metadata.get(XMPDM.ALBUM)), properties);
        this.putRawValue(KEY_SONG_TITLE, (Serializable)((Object)metadata.get(TikaCoreProperties.TITLE)), properties);
        this.putRawValue(KEY_ARTIST, (Serializable)((Object)metadata.get(XMPDM.ARTIST)), properties);
        this.putRawValue(KEY_COMMENT, (Serializable)((Object)metadata.get(XMPDM.LOG_COMMENT)), properties);
        this.putRawValue(KEY_TRACK_NUMBER, (Serializable)((Object)metadata.get(XMPDM.TRACK_NUMBER)), properties);
        this.putRawValue(KEY_GENRE, (Serializable)((Object)metadata.get(XMPDM.GENRE)), properties);
        this.putRawValue(KEY_YEAR_RELEASED, (Serializable)((Object)metadata.get(XMPDM.RELEASE_DATE)), properties);
        this.putRawValue(KEY_COMPOSER, (Serializable)((Object)metadata.get(XMPDM.COMPOSER)), properties);
        return properties;
    }
}

