/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.tika.metadata;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.transform.base.TransformManager;
import org.alfresco.transform.base.metadata.AbstractMetadataExtractorEmbedder;
import org.alfresco.transform.tika.metadata.AbstractTikaMetadataExtractorEmbeddor;
import org.apache.tika.embedder.Embedder;
import org.apache.tika.extractor.DocumentSelector;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.slf4j.Logger;
import org.xml.sax.ContentHandler;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractTikaMetadataExtractorEmbeddor
extends AbstractMetadataExtractorEmbedder {
    protected static final String KEY_AUTHOR = "author";
    protected static final String KEY_TITLE = "title";
    protected static final String KEY_SUBJECT = "subject";
    protected static final String KEY_CREATED = "created";
    protected static final String KEY_DESCRIPTION = "description";
    protected static final String KEY_COMMENTS = "comments";
    protected static final String KEY_TAGS = DublinCore.SUBJECT.getName();
    private static final String METADATA_SEPARATOR = ",";
    private final DateTimeFormatter tikaUTCDateFormater;
    private final DateTimeFormatter tikaDateFormater;

    protected AbstractTikaMetadataExtractorEmbeddor(AbstractMetadataExtractorEmbedder.Type type, Logger logger) {
        super(type, logger);
        DateTimeParser[] parsersUTC = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ").getParser()};
        DateTimeParser[] parsers = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd").getParser(), DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"yyyy/MM/dd").getParser(), DateTimeFormat.forPattern((String)"EEE MMM dd hh:mm:ss zzz yyyy").getParser()};
        this.tikaUTCDateFormater = new DateTimeFormatterBuilder().append(null, parsersUTC).toFormatter().withZone(DateTimeZone.UTC);
        this.tikaDateFormater = new DateTimeFormatterBuilder().append(null, parsers).toFormatter();
    }

    protected Serializable makeDate(String dateStr) {
        try {
            return this.tikaUTCDateFormater.parseDateTime(dateStr).toDate();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return this.tikaUTCDateFormater.withLocale(Locale.US).parseDateTime(dateStr).toDate();
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    return this.tikaDateFormater.parseDateTime(dateStr).toDate();
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        return this.tikaDateFormater.withLocale(Locale.US).parseDateTime(dateStr).toDate();
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        return dateStr;
                    }
                }
            }
        }
    }

    protected abstract Parser getParser();

    protected Embedder getEmbedder() {
        return null;
    }

    protected boolean needHeaderContents() {
        return false;
    }

    protected Map<String, Serializable> extractSpecific(Metadata metadata, Map<String, Serializable> properties, Map<String, String> headers) {
        return properties;
    }

    protected DocumentSelector getDocumentSelector(Metadata metadata, String targetMimeType) {
        return null;
    }

    private ParseContext buildParseContext(Metadata metadata, String sourceMimeType) {
        ParseContext context = new ParseContext();
        DocumentSelector selector = this.getDocumentSelector(metadata, sourceMimeType);
        if (selector != null) {
            context.set(DocumentSelector.class, (Object)selector);
        }
        return context;
    }

    public Map<String, Serializable> extractMetadata(String sourceMimetype, InputStream inputStream, String targetMimetype, OutputStream outputStream, Map<String, String> transformOptions, TransformManager transformManager) throws Exception {
        NullContentHandler handler;
        HashMap<String, Serializable> rawProperties = new HashMap();
        Parser parser = this.getParser();
        Metadata metadata = new Metadata();
        metadata.add("Content-Type", sourceMimetype);
        ParseContext context = this.buildParseContext(metadata, sourceMimetype);
        Map headers = null;
        if (this.needHeaderContents()) {
            String[] headerCapture = new MapCaptureContentHandler();
            headers = headerCapture.tags;
            handler = new HeadContentHandler((ContentHandler)headerCapture);
        } else {
            handler = new NullContentHandler();
        }
        parser.parse(inputStream, (ContentHandler)handler, metadata, context);
        for (String tikaKey : metadata.names()) {
            this.putRawValue(tikaKey, (Serializable)((Object)this.getMetadataValue(metadata, Property.internalText((String)tikaKey))), rawProperties);
        }
        this.putRawValue("author", (Serializable)((Object)this.getMetadataValue(metadata, TikaCoreProperties.CREATOR)), rawProperties);
        this.putRawValue("title", (Serializable)((Object)this.getMetadataValue(metadata, TikaCoreProperties.TITLE)), rawProperties);
        this.putRawValue("comments", (Serializable)((Object)this.getMetadataValue(metadata, TikaCoreProperties.COMMENTS)), rawProperties);
        this.putRawValue(KEY_TAGS, this.getMetadataValues(metadata, KEY_TAGS), rawProperties);
        String subject = this.getMetadataValue(metadata, TikaCoreProperties.SUBJECT);
        String description = this.getMetadataValue(metadata, TikaCoreProperties.DESCRIPTION);
        if (subject != null && description != null) {
            this.putRawValue("description", (Serializable)((Object)description), rawProperties);
            this.putRawValue("subject", (Serializable)((Object)subject), rawProperties);
        } else if (subject != null) {
            this.putRawValue("description", (Serializable)((Object)subject), rawProperties);
            this.putRawValue("subject", (Serializable)((Object)subject), rawProperties);
        } else if (description != null) {
            this.putRawValue("description", (Serializable)((Object)description), rawProperties);
            this.putRawValue("subject", (Serializable)((Object)description), rawProperties);
        }
        if (metadata.get(TikaCoreProperties.CREATED) != null) {
            this.putRawValue("created", (Serializable)((Object)metadata.get(TikaCoreProperties.CREATED)), rawProperties);
        } else if (metadata.get(TikaCoreProperties.MODIFIED) != null) {
            this.putRawValue("created", (Serializable)((Object)metadata.get(TikaCoreProperties.MODIFIED)), rawProperties);
        }
        rawProperties = this.extractSpecific(metadata, rawProperties, headers);
        return rawProperties;
    }

    public void embedMetadata(String sourceMimetype, InputStream inputStream, String targetMimetype, OutputStream outputStream, Map<String, String> transformOptions, TransformManager transformManager) throws Exception {
        Embedder embedder = this.getEmbedder();
        if (embedder == null) {
            return;
        }
        Metadata metadataToEmbed = this.getTikaMetadata(transformOptions);
        embedder.embed(metadataToEmbed, inputStream, outputStream, null);
    }

    private Metadata getTikaMetadata(Map<String, String> transformOptions) {
        Metadata metadataToEmbed = new Metadata();
        Map properties = this.getMetadata(transformOptions);
        for (String metadataKey : properties.keySet()) {
            Serializable value = (Serializable)properties.get(metadataKey);
            if (value == null) continue;
            if (value instanceof Collection) {
                for (Object singleValue : (Collection)((Object)value)) {
                    try {
                        metadataToEmbed.add(metadataKey, (String)singleValue);
                    }
                    catch (ClassCastException e) {
                        this.logger.info("Could not convert " + metadataKey + ": " + e.getMessage());
                    }
                }
                continue;
            }
            try {
                metadataToEmbed.add(metadataKey, (String)((Object)value));
            }
            catch (ClassCastException e) {
                this.logger.info("Could not convert " + metadataKey + ": " + e.getMessage());
            }
        }
        return metadataToEmbed;
    }

    private Serializable getMetadataValues(Metadata metadata, String key) {
        LinkedHashSet<String> valuesSet = new LinkedHashSet<String>();
        String[] values = metadata.getValues(key);
        for (int i = 0; i < values.length; ++i) {
            String[] parts;
            for (String subPart : parts = values[i].split(",")) {
                valuesSet.add(subPart.trim());
            }
        }
        Object[] objArrayValues = valuesSet.toArray();
        values = (String[])Arrays.copyOf(objArrayValues, objArrayValues.length, String[].class);
        return values.length == 0 ? null : (values.length == 1 ? values[0] : values);
    }

    private String getMetadataValue(Metadata metadata, Property key) {
        if (metadata.isMultiValued(key)) {
            return AbstractTikaMetadataExtractorEmbeddor.distinct((String[])metadata.getValues(key)).collect(Collectors.joining(", "));
        }
        return metadata.get(key);
    }

    protected static Stream<String> distinct(String[] strings) {
        return Stream.of(strings).filter(Objects::nonNull).map(String::strip).filter(s -> !s.isEmpty()).distinct();
    }
}

