/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.util;

import org.alfresco.repo.event.util.DataAttributesUtils;
import org.alfresco.repo.event.v1.model.ContentInfo;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.Resource;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class DataAttributesUtilsTest {
    @Mock
    private DataAttributes<Resource> dataAttributes;
    @Mock
    private NodeResource nodeResource;
    @Mock
    private ContentInfo contentInfo;

    DataAttributesUtilsTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.lenient().when((Object)this.dataAttributes.getResource()).thenReturn((Object)this.nodeResource);
        Mockito.lenient().when((Object)this.nodeResource.getContent()).thenReturn((Object)this.contentInfo);
    }

    @ParameterizedTest
    @ValueSource(longs={1L, 100L, 0x7FFFFFFFFFFFFFFFL})
    void testContainsNotBlankContent_contentSizeGreaterThanZero(Long contentSize) {
        Mockito.when((Object)this.contentInfo.getSizeInBytes()).thenReturn((Object)contentSize);
        Assertions.assertThat((boolean)DataAttributesUtils.containsNotBlankContent(this.dataAttributes)).isTrue();
    }

    @ParameterizedTest
    @ValueSource(longs={0L, -100L, -9223372036854775808L})
    void testContainsNotBlankContent_contentSizeNotGreaterThanZero(Long contentSize) {
        Mockito.when((Object)this.contentInfo.getSizeInBytes()).thenReturn((Object)contentSize);
        Assertions.assertThat((boolean)DataAttributesUtils.containsNotBlankContent(this.dataAttributes)).isFalse();
    }

    @Test
    void testContainsNotBlankContent_nullSizeInBytes() {
        Mockito.when((Object)this.contentInfo.getSizeInBytes()).thenReturn(null);
        Assertions.assertThat((boolean)DataAttributesUtils.containsNotBlankContent(this.dataAttributes)).isFalse();
    }

    @Test
    void testContainsNotBlankContent_nullContentSize() {
        Mockito.when((Object)this.nodeResource.getContent()).thenReturn(null);
        Assertions.assertThat((boolean)DataAttributesUtils.containsNotBlankContent(this.dataAttributes)).isFalse();
    }

    @Test
    void testContainsNotBlankContent_resourceNull() {
        Mockito.when((Object)this.dataAttributes.getResource()).thenReturn(null);
        Assertions.assertThat((boolean)DataAttributesUtils.containsNotBlankContent(this.dataAttributes)).isFalse();
    }

    @Test
    void testContainsNotBlankContent_dataAttributesNull() {
        Assertions.assertThat((boolean)DataAttributesUtils.containsNotBlankContent(null)).isFalse();
    }

    @Test
    void testContainsNotBlankContent_notNodeResource() {
        Mockito.when((Object)this.dataAttributes.getResource()).thenReturn((Object)((Resource)Mockito.mock(Resource.class)));
        Assertions.assertThat((boolean)DataAttributesUtils.containsNotBlankContent(this.dataAttributes)).isFalse();
    }
}

