/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.util;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.alfresco.repo.event.extension.ExtensionAttributes;
import org.alfresco.repo.event.extension.ExtensionAttributesImpl;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventData;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event.v1.model.Resource;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.junit.jupiter.api.Assertions;
import uk.co.jemos.podam.api.AbstractRandomDataProviderStrategy;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamFactory;
import uk.co.jemos.podam.api.PodamFactoryImpl;

public class RandomModelGenerator {
    private static final PodamFactory POJO_FACTORY = new PodamFactoryImpl((DataProviderStrategy)new EventModelGenStrategy());

    private RandomModelGenerator() {
    }

    public static NodeResource generateNodeResource() {
        NodeResource pojo = (NodeResource)POJO_FACTORY.manufacturePojoWithFullData(NodeResource.class, new Type[0]);
        RandomModelGenerator.assertAllFieldsAreSet(pojo);
        return pojo;
    }

    public static <R extends Resource> EventData<R> generateEventData() {
        EventData pojo = (EventData)POJO_FACTORY.manufacturePojoWithFullData(EventData.class, new Type[]{NodeResource.class});
        RandomModelGenerator.assertAllFieldsAreSet(pojo);
        return pojo;
    }

    public static <D extends DataAttributes<? extends Resource>> RepoEvent<D> generateRepoEvent() {
        RepoEvent pojo = (RepoEvent)POJO_FACTORY.manufacturePojoWithFullData(RepoEvent.class, new Type[]{TypeUtils.parameterize(EventData.class, (Type[])new Type[]{NodeResource.class})});
        RandomModelGenerator.assertAllFieldsAreSet(pojo);
        return pojo;
    }

    static void assertAllFieldsAreSet(Object obj) {
        try {
            for (Field field : obj.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Assertions.assertNotNull((Object)field.get(obj), (String)field.getName());
                if (field.getType().isPrimitive()) continue;
                RandomModelGenerator.assertAllFieldsAreSet(field);
            }
        }
        catch (IllegalAccessException e) {
            Assertions.fail((String)"all fields should be accessible in this test");
        }
    }

    static class EventModelGenStrategy
    extends AbstractRandomDataProviderStrategy {
        EventModelGenStrategy() {
        }

        public <T> Class<? extends T> getSpecificClass(Class<T> nonInstantiatableClass) {
            if (nonInstantiatableClass.equals(ExtensionAttributes.class)) {
                return ExtensionAttributesImpl.class;
            }
            return super.getSpecificClass(nonInstantiatableClass);
        }
    }
}

